/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.enchantment_color;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentGroup;
import net.kapitencraft.kap_lib.client.enchantment_color.LevelRange;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record EnchantmentColor(String name, List<Enchantment> elements, List<EnchantmentGroup> groups, @Nullable LevelRange levelRange, Style targetStyle) {
    static final Codec<EnchantmentColor> CODEC = RecordCodecBuilder.create(enchantmentColorInstance -> enchantmentColorInstance.group((App)Codec.STRING.fieldOf("name").forGetter(EnchantmentColor::name), (App)ForgeRegistries.ENCHANTMENTS.getCodec().listOf().optionalFieldOf("elements", List.of()).forGetter(EnchantmentColor::elements), (App)EnchantmentGroup.CODEC.listOf().optionalFieldOf("groups", List.of()).forGetter(EnchantmentColor::groups), (App)LevelRange.CODEC.optionalFieldOf("levelRange").forGetter(c -> Optional.ofNullable(c.levelRange)), (App)ExtraCodecs.EFFECT_SERIALIZING_STYLE.fieldOf("style").forGetter(EnchantmentColor::targetStyle)).apply((Applicative)enchantmentColorInstance, EnchantmentColor::fromCodec));

    private static EnchantmentColor fromCodec(String name, List<Enchantment> elements, List<EnchantmentGroup> groups, Optional<LevelRange> levelRange, Style targetStyle) {
        return EnchantmentColor.create(name, elements, groups, levelRange.orElse(null), targetStyle);
    }

    public static EnchantmentColor create(String name, List<Enchantment> elements, List<EnchantmentGroup> groups, @Nullable LevelRange range, Style targetStyle) {
        return new EnchantmentColor(name, new ArrayList<Enchantment>(elements), new ArrayList<EnchantmentGroup>(groups), range, targetStyle);
    }

    public Style getStyleForEnchantment(Enchantment enchantment, int level) {
        if (!this.groups.isEmpty() && this.groups.stream().noneMatch(g -> g.is(enchantment))) {
            return null;
        }
        if (!this.elements.isEmpty() && !this.elements.contains(enchantment)) {
            return null;
        }
        if (this.levelRange != null && !this.levelRange.test(level, enchantment.m_6586_())) {
            return null;
        }
        return this.targetStyle;
    }
}

