/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.GroupSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.LineSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.RingSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface AnimationUtils {
    public static ParticleAnimation.Builder star(int tips, ParticleOptions starType, @Nullable ParticleOptions ringType, float spacing, float radius, PositionTarget origin) {
        float angleBetweenTips = 360.0f / (float)tips * 2.0f;
        GroupSpawner.Builder spawner = GroupSpawner.builder();
        for (int i = 0; i < tips; ++i) {
            spawner.addSpawner((Spawner.Builder)LineSpawner.builder().start(PositionTarget.relative(origin, AnimationUtils.point(angleBetweenTips * (float)i).m_82490_((double)radius))).end(PositionTarget.relative(origin, AnimationUtils.point(angleBetweenTips * (float)(i + 1)).m_82490_((double)radius))).spacing(spacing).setParticle(starType));
        }
        if (ringType != null) {
            spawner.addSpawner((Spawner.Builder)RingSpawner.fullCircle(360).axis(Direction.Axis.Y).radius(radius).setTarget(origin).setParticle(ringType));
        }
        return ParticleAnimation.builder().spawn(spawner).spawnTime(ParticleAnimation.SpawnTime.once());
    }

    private static Vec3 point(float angle) {
        return new Vec3((double)Mth.m_14031_((float)(angle *= (float)Math.PI / 180)), 0.0, (double)Mth.m_14089_((float)angle));
    }
}

