/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.core;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.ActivationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.TriggerInstance;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimator;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.TimedTerminator;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.TerminatorTriggers;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public final class ParticleAnimationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    List<ParticleAnimator> activeAnimations = new ArrayList<ParticleAnimator>();
    Map<ParticleAnimator, List<TriggerInstance>> onHold = new HashMap<ParticleAnimator, List<TriggerInstance>>();

    @ApiStatus.Internal
    public void accept(ParticleAnimation animation) {
        ParticleAnimator animator;
        TriggerInstance[] triggers = animation.getTriggers();
        if (triggers.length > 0) {
            animator = new ParticleAnimator(animation);
            ArrayList<TriggerInstance> remaining = new ArrayList<TriggerInstance>();
            for (TriggerInstance instance : triggers) {
                ActivationTrigger.Listener<TriggerInstance> listener = new ActivationTrigger.Listener<TriggerInstance>(instance, animator);
                this.addListener(listener, remaining);
            }
            if (!remaining.isEmpty()) {
                this.onHold.put(animator, remaining);
                return;
            }
        }
        animator = new ParticleAnimator(animation);
        this.activeAnimations.add(animator);
    }

    private <T extends TriggerInstance> void addListener(ActivationTrigger.Listener<T> instance, List<TriggerInstance> target) {
        ActivationTrigger<? extends TriggerInstance> trigger = instance.getTrigger().getTrigger();
        if (!trigger.active(instance)) {
            trigger.addListener(instance);
            target.add((TriggerInstance)instance.getTrigger());
        }
    }

    @ApiStatus.Internal
    public void tick(RandomSource source) {
        ((TimedTerminator)TerminatorTriggers.TIMED.get()).trigger();
        this.activeAnimations.forEach(pa -> {
            try {
                pa.tick(source);
            }
            catch (Exception e) {
                CrashReport report = new CrashReport("ParticleAnimation Error", (Throwable)e);
                report.m_127514_("Manager").m_128159_("On Hold", (Object)this.onHold.size()).m_128159_("Active", (Object)this.activeAnimations.size());
                pa.fillCrashReport(report);
                throw new ReportedException(report);
            }
        });
    }

    public void triggerComplete(ParticleAnimator animator, TriggerInstance trigger) {
        List<TriggerInstance> triggers = this.onHold.get(animator);
        triggers.remove(trigger);
        if (triggers.isEmpty()) {
            this.onHold.remove(animator);
            this.activeAnimations.add(animator);
        }
    }

    public void remove(ParticleAnimator animator) {
        this.activeAnimations.remove(animator);
    }
}

