/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.VisibleSpawner;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityBBSpawner
extends VisibleSpawner {
    private final int targetId;
    private final boolean onlyOutline;
    private final float sizeXScale;
    private final float sizeYScale;
    private final int perTick;

    protected EntityBBSpawner(ParticleOptions particle, int targetId, boolean onlyOutline, float sizeXScale, float sizeYScale, int perTick) {
        super(particle);
        this.targetId = targetId;
        this.onlyOutline = onlyOutline;
        this.sizeXScale = sizeXScale;
        this.sizeYScale = sizeYScale;
        this.perTick = perTick;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        Entity target = ClientHelper.getEntity(this.targetId);
        float bbRadius = target.m_20205_() / 2.0f;
        AABB box = target.m_20191_();
        for (int i = 0; i < this.perTick; ++i) {
            Vec3 pos = MathHelper.randomIn(sink.random, box);
            if (this.onlyOutline) {
                float c = sink.random.m_188501_();
                pos = c < 0.33333334f ? (c < 0.16666667f ? pos.m_193103_(Direction.Axis.X, box.f_82288_) : pos.m_193103_(Direction.Axis.X, box.f_82291_)) : (c < 0.6666667f ? ((double)c < 0.5 ? pos.m_193103_(Direction.Axis.Y, box.f_82289_) : pos.m_193103_(Direction.Axis.Y, box.f_82292_)) : (c < 0.8333333f ? pos.m_193103_(Direction.Axis.Z, box.f_82290_) : pos.m_193103_(Direction.Axis.Z, box.f_82293_)));
            }
            sink.accept(this.particle, pos);
        }
    }

    @NotNull
    public Type getType() {
        return (Type)SpawnerTypes.ENTITY_BB.get();
    }

    public static class Builder
    extends VisibleSpawner.Builder<Builder> {
        private Entity target;
        private boolean onlyOutline;
        private float xScale = 1.0f;
        private float yScale = 1.0f;
        private int perTick;

        public Builder target(Entity target) {
            this.target = target;
            return this;
        }

        public Builder onlyOutline() {
            this.onlyOutline = true;
            return this;
        }

        public Builder scaleX(float xScale) {
            this.xScale *= xScale;
            return this;
        }

        public Builder scaleY(float yScale) {
            this.yScale *= yScale;
            return this;
        }

        @Override
        public VisibleSpawner build() {
            return new EntityBBSpawner(this.particle, this.target.m_19879_(), this.onlyOutline, this.xScale, this.yScale, this.perTick);
        }

        public Builder perTick(int perTick) {
            this.perTick = perTick;
            return this;
        }
    }

    public static class Type
    implements Spawner.Type<EntityBBSpawner> {
        @Override
        public void toNW(FriendlyByteBuf buf, EntityBBSpawner value) {
            NetworkHelper.writeParticleOptions(buf, value.particle);
            buf.writeInt(value.targetId);
            buf.writeBoolean(value.onlyOutline);
            buf.writeFloat(value.sizeXScale);
            buf.writeFloat(value.sizeYScale);
            buf.writeInt(value.perTick);
        }

        @Override
        public EntityBBSpawner fromNw(FriendlyByteBuf buf, ClientLevel level) {
            return new EntityBBSpawner((ParticleOptions)NetworkHelper.readParticleOptions(buf), buf.readInt(), buf.readBoolean(), buf.readFloat(), buf.readFloat(), buf.readInt());
        }
    }
}

