/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import net.kapitencraft.kap_lib.client.ExtraComponents;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.cam.core.TrackingShot;
import net.kapitencraft.kap_lib.client.cam.modifiers.GlideTowardsModifier;
import net.kapitencraft.kap_lib.client.glyph.player_head.PlayerHeadAllocator;
import net.kapitencraft.kap_lib.client.gui.screen.TestScreen;
import net.kapitencraft.kap_lib.client.particle.LightningParticleOptions;
import net.kapitencraft.kap_lib.client.particle.ShimmerShieldParticleOptions;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.CommandHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.registry.custom.GlyphEffects;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ClientTestCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"client_test").then(Commands.m_82127_((String)"screen").executes(ClientHelper.createScreenCommand(TestScreen::new)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"particle").then(Commands.m_82127_((String)"shield").executes(ClientTestCommand::spawnShieldParticle))).then(Commands.m_82127_((String)"lightning").executes(ClientTestCommand::spawnLightningParticle)))).then(Commands.m_82127_((String)"chroma").executes(ClientTestCommand::testChroma))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"shake").executes(ClientTestCommand::shakeNoArg)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"intensity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ClientTestCommand::shakeIntensity)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"strength", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(ClientTestCommand::shakeIntensityStrength)).then(Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.01f, (float)5.0f)).executes(ClientTestCommand::shakeAll)))))).then(Commands.m_82127_((String)"cam").executes(ClientTestCommand::testCameraMotion))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"glyph").executes(ClientTestCommand::testGlyphs)).then(Commands.m_82127_((String)"reset").executes(ClientTestCommand::resetGlyphs))));
    }

    private static int resetGlyphs(CommandContext<CommandSourceStack> context) {
        PlayerHeadAllocator.getInstance().reset();
        return 1;
    }

    private static int testGlyphs(CommandContext<CommandSourceStack> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        UUID uuid = player.m_20148_();
        player.m_213846_((Component)ExtraComponents.playerHead(uuid));
        return 1;
    }

    private static int testCameraMotion(CommandContext<CommandSourceStack> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        LibClient.cameraControl.activate(TrackingShot.builder().addModifier(new GlideTowardsModifier(PositionTarget.entityEyes((Entity)player), PositionTarget.fixed(player.m_20252_(0.0f).m_82490_(20.0).m_82549_(EntityAnchorArgument.Anchor.EYES.m_90377_((Entity)player)))), 40).build());
        return 1;
    }

    private static int shakeAll(CommandContext<CommandSourceStack> context) {
        return ClientTestCommand.shake(FloatArgumentType.getFloat(context, (String)"intensity"), FloatArgumentType.getFloat(context, (String)"strength"), FloatArgumentType.getFloat(context, (String)"speed"));
    }

    private static int shakeIntensityStrength(CommandContext<CommandSourceStack> context) {
        return ClientTestCommand.shake(FloatArgumentType.getFloat(context, (String)"intensity"), FloatArgumentType.getFloat(context, (String)"strength"), 1.5f);
    }

    private static int shakeIntensity(CommandContext<CommandSourceStack> context) {
        return ClientTestCommand.shake(FloatArgumentType.getFloat(context, (String)"intensity"), 0.5f, 1.5f);
    }

    private static int shakeNoArg(CommandContext<CommandSourceStack> commandSourceStackCommandContext) {
        return ClientTestCommand.shake(0.01f, 0.5f, 1.5f);
    }

    private static int shake(float intensity, float strength, float speed) {
        LibClient.cameraControl.shake(intensity, strength, speed);
        return 1;
    }

    private static int testChroma(CommandContext<CommandSourceStack> commandContext) {
        for (int i = 0; i < 10; ++i) {
            ((CommandSourceStack)commandContext.getSource()).m_243053_((Component)Component.m_237113_((String)"EEEEEEEEEEEEEEEEEE").m_6270_(MiscHelper.withSpecial(Style.f_131099_, GlyphEffects.RAINBOW)));
        }
        return 1;
    }

    private static int spawnShieldParticle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ((CommandSourceStack)context.getSource()).m_81374_().m_9236_().m_6493_((ParticleOptions)new ShimmerShieldParticleOptions(100, 50, Minecraft.m_91087_().f_91074_.m_19879_(), 5, 10, 1000, Color.fromARGBPacked(-65536), Color.fromARGBPacked(-16711936), 0.01f, UUID.randomUUID()), true, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        CommandHelper.sendSuccess((CommandSourceStack)context.getSource(), "success!", new Object[0]);
        return 1;
    }

    private static int spawnLightningParticle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81374_();
        Level level = entity.m_9236_();
        level.m_6493_((ParticleOptions)new LightningParticleOptions(new Vec3(0.0, 0.0, -10.0), new Vec3(10.0, 0.0, 0.0), 5, 1000, 1.5f, 0.2f), true, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, 0.0, 0.0, -10.0, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        return 1;
    }
}

