/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.abstracts;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kapitencraft.kap_lib.enchantments.abstracts.ExtendedCalculationEnchantment;
import net.kapitencraft.kap_lib.enchantments.abstracts.IWeaponEnchantment;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.io.serialization.NbtSerializer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

public interface CountEnchantment
extends ExtendedCalculationEnchantment,
IWeaponEnchantment {
    public static final Codec<Map<UUID, Integer>> DATA_CODEC = Codec.unboundedMap((Codec)UUIDUtil.f_260719_, (Codec)Codec.INT);
    public static final NbtSerializer<Map<UUID, Integer>> SERIALIZER = new NbtSerializer<Map>(DATA_CODEC, HashMap::new);

    @ApiStatus.Internal
    default public String mapName() {
        return Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)this)), "unknown enchantment").toString();
    }

    public CountType countType();

    public int getCountAmount(int var1);

    @Override
    default public float execute(int level, ItemStack enchanted, LivingEntity attacker, LivingEntity attacked, float damageAmount, DamageSource source, float attackStrenghtScale) {
        String mapName;
        CompoundTag attackerTag = IOHelper.getOrCreateTag(attacker.getPersistentData(), "CountEnchantment");
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>((Map)SERIALIZER.parse((Map<UUID, Integer>)(attackerTag.m_128425_(mapName = this.mapName(), 10) ? attackerTag.m_128423_(mapName) : new CompoundTag())));
        map.putIfAbsent(attacked.m_20148_(), 1);
        int i = (Integer)map.get(attacked.m_20148_());
        if (i >= this.getCountAmount(level)) {
            if (this.countType() != CountType.EXCEPT) {
                damageAmount = this.mainExecute(level, enchanted, attacker, attacked, damageAmount, 0, source, attackStrenghtScale);
            }
            i = this.countType() == CountType.ONCE ? -1 : 1;
        } else if (i >= 0) {
            if (this.countType() != CountType.NORMAL) {
                damageAmount = this.mainExecute(level, enchanted, attacker, attacked, damageAmount, i, source, attackStrenghtScale);
            }
            ++i;
        }
        map.put(attacked.m_20148_(), i);
        attackerTag.m_128365_(mapName, (Tag)SERIALIZER.encode(map));
        return damageAmount;
    }

    public float mainExecute(int var1, ItemStack var2, LivingEntity var3, LivingEntity var4, float var5, int var6, DamageSource var7, float var8);

    public static enum CountType {
        NORMAL,
        EXCEPT,
        ONCE;

    }
}

