/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Compacting {
    private static final Map<Item, Result> resultCache = new HashMap<Item, Result>();

    public static Result tryCompact(Item in, ServerLevel level) {
        if (resultCache.containsKey(in)) {
            return resultCache.get(in);
        }
        RecipeManager manager = level.m_7465_();
        Optional smallRecipe = manager.m_44015_(RecipeType.f_44107_, (net.minecraft.world.Container)new Container(true, in), (Level)level);
        Optional largeRecipe = manager.m_44015_(RecipeType.f_44107_, (net.minecraft.world.Container)new Container(false, in), (Level)level);
        Result result = smallRecipe.isEmpty() && largeRecipe.isEmpty() ? Result.EMPTY : new Result(smallRecipe.map(craftingRecipe -> craftingRecipe.m_8043_(level.m_9598_())).orElse(null), largeRecipe.map(craftingRecipe -> craftingRecipe.m_8043_(level.m_9598_())).orElse(null));
        resultCache.put(in, result);
        return result;
    }

    public static class Result {
        public static final Result EMPTY = new Result(null, null);
        @Nullable
        private final ItemStack small;
        @Nullable
        private final ItemStack large;

        private Result(@Nullable ItemStack small, @Nullable ItemStack large) {
            this.small = small;
            this.large = large;
        }

        public boolean successful() {
            return this.small != null || this.large != null;
        }

        public boolean isSmall() {
            return this.successful() && this.small != null;
        }

        public int getCountReq() {
            return this.small != null ? 4 : (this.large != null ? 9 : -1);
        }

        @Nullable
        public ItemStack result() {
            return this.small != null ? this.small : this.large;
        }

        @Nullable
        public ItemStack getSmall() {
            return this.small;
        }

        @Nullable
        public ItemStack getLarge() {
            return this.large;
        }
    }

    private static class Container
    implements CraftingContainer {
        private final boolean small;
        private final ItemStack val;

        private Container(boolean small, Item in) {
            this.small = small;
            this.val = new ItemStack((ItemLike)in);
        }

        public int m_39347_() {
            return this.small ? 2 : 3;
        }

        public int m_39346_() {
            return this.small ? 2 : 3;
        }

        @NotNull
        public List<ItemStack> m_280657_() {
            return List.of();
        }

        public int m_6643_() {
            return this.small ? 4 : 9;
        }

        public boolean m_7983_() {
            return false;
        }

        public ItemStack m_8020_(int pSlot) {
            return this.val;
        }

        public ItemStack m_7407_(int pSlot, int pAmount) {
            return null;
        }

        public ItemStack m_8016_(int pSlot) {
            return null;
        }

        public void m_6836_(int pSlot, ItemStack pStack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player pPlayer) {
            return false;
        }

        public void m_6211_() {
        }

        public void m_5809_(StackedContents pContents) {
        }
    }
}

