/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.modifier_display;

import com.google.common.collect.Multimap;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface DisplayExtension<T> {
    default public Component createComponent(double value) {
        Type type = this.getType();
        if (type == Type.NONE) {
            return CommonComponents.f_237098_;
        }
        return Component.m_237113_((String)(type.open + (value < 0.0 ? "" : "+") + ItemStack.f_41584_.format(value) + type.close)).m_130948_(this.getStyle());
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getModifiers(T var1);

    public Style getStyle();

    public Type getType();

    public static enum Type implements StringRepresentable
    {
        NONE(' ', ' '),
        CURLY('{', '}'),
        SQUARE('[', ']'),
        DEFAULT('(', ')'),
        POINTY('<', '>');

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private final char open;
        private final char close;

        private Type(char open, char close) {
            this.open = open;
            this.close = close;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }
}

