/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes;

import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.mixin.duck.ScaledClientMotionPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ClientboundSetEntityMotionPacket.class})
public class ClientboundSetEntityMotionPacketMixin
implements ScaledClientMotionPacket {
    @Shadow
    private int f_133177_;
    @Shadow
    private int f_133178_;
    @Shadow
    private int f_133179_;
    @Unique
    private float deltaScale;

    @Inject(method={"<init>(ILnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void calculateScale(int pId, Vec3 pDeltaMovement, CallbackInfo ci, double d0, double d1, double d2) {
        this.deltaScale = MathHelper.getOversizeScale(pDeltaMovement, new Vec3(d0, d1, d2));
        this.f_133177_ = (int)(pDeltaMovement.f_82479_ * (double)this.deltaScale * 8000.0);
        this.f_133178_ = (int)(pDeltaMovement.f_82480_ * (double)this.deltaScale * 8000.0);
        this.f_133179_ = (int)(pDeltaMovement.f_82481_ * (double)this.deltaScale * 8000.0);
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="TAIL")})
    private void readScaleFromNW(FriendlyByteBuf pBuffer, CallbackInfo ci) {
        this.deltaScale = pBuffer.readFloat();
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void addScaleToNW(FriendlyByteBuf pBuffer, CallbackInfo ci) {
        pBuffer.writeFloat(this.deltaScale);
    }

    @Override
    public float getScale() {
        return this.deltaScale;
    }
}

