/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes;

import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.mixin.duck.attribute.IKapLibAttributeMap;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ExtraMobEffects;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeLivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IForgeLivingEntity {
    @Shadow
    @Final
    private AttributeMap f_20943_;

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    public LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"updateFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkRequirements(CallbackInfo ci) {
        if (!this.m_9236_().m_5776_() && !RequirementManager.instance.meetsRequirements(RegistryReqType.ITEM, this.m_6844_(EquipmentSlot.CHEST).m_41720_(), this.self())) {
            this.m_20115_(7, false);
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void addAttributeTick(CallbackInfo ci) {
        IKapLibAttributeMap.of(this.f_20943_).tick();
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtArmor(Lnet/minecraft/world/damagesource/DamageSource;F)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void getDamageAfterArmorAbsorb(DamageSource source, float damage, CallbackInfoReturnable<Float> cir) {
        double d;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            d = AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.ARMOR_SHREDDER.get(), living);
        } else {
            d = 0.0;
        }
        double armorShredValue = d;
        double armorValue = Math.max(0.0, this.getArmorValue(source) - armorShredValue);
        cir.setReturnValue((Object)Float.valueOf(MathHelper.calculateDamage(damage, (float)armorValue, (float)this.self().m_21133_(Attributes.f_22285_))));
    }

    @Unique
    private double getArmorValue(DamageSource source) {
        if (source.m_19385_().equals("true_damage")) {
            return AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.TRUE_DEFENCE.get(), this.self());
        }
        return AttributeHelper.getSaveAttributeValue(Attributes.f_22284_, this.self());
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN", ordinal=6)})
    public void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        Entity entity;
        if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double attackSpeed = AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.BONUS_ATTACK_SPEED.get(), living);
            if (attackSpeed > 0.0) {
                this.self().f_19802_ = (int)(20.0 - attackSpeed * 0.15);
            }
        }
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD")}, cancellable=true)
    private void addStunEffect(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_21023_((MobEffect)ExtraMobEffects.STUN.get())) {
            cir.setReturnValue((Object)true);
        }
    }
}

