/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.io.serialization.JsonSerializer;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AddEffectsFunction
extends SpawnEntityConditionalFunction {
    public static final JsonSerializer<List<MobEffectInstance>> EFFECT_SERIALIZER = new JsonSerializer<List>(ExtraCodecs.EFFECT.listOf(), List::of);
    private final MobEffectInstance[] effects;

    protected AddEffectsFunction(LootItemCondition[] pPredicates, MobEffectInstance[] effects) {
        super(pPredicates);
        this.effects = effects;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            for (MobEffectInstance effect : this.effects) {
                living.m_7292_(effect);
            }
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType getType() {
        return (SpawnEntityFunctionType)((Object)SpawnEntityFunctions.ADD_EFFECTS.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();

        private Builder() {
        }

        public Builder withEffect(MobEffectInstance instance) {
            this.effects.add(instance);
            return this;
        }

        public Builder withEffect(MobEffect effect, int duration) {
            return this.withEffect(new MobEffectInstance(effect, duration));
        }

        public Builder withEffect(MobEffect effect, int duration, int amplifier) {
            return this.withEffect(new MobEffectInstance(effect, duration, amplifier));
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new AddEffectsFunction(this.getConditions(), (MobEffectInstance[])this.effects.toArray(MobEffectInstance[]::new));
        }
    }

    public static class Serializer
    extends SpawnEntityConditionalFunction.Serializer<AddEffectsFunction> {
        @Override
        public void serialize(JsonObject pJson, AddEffectsFunction pFunction, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pFunction, pSerializationContext);
            pJson.add("effects", (JsonElement)EFFECT_SERIALIZER.encode(List.of(pFunction.effects)));
        }

        @Override
        public AddEffectsFunction deserialize(JsonObject pObject, JsonDeserializationContext pDeserializationContext, LootItemCondition[] pConditions) {
            MobEffectInstance[] effects = (MobEffectInstance[])((List)EFFECT_SERIALIZER.parse((List<MobEffectInstance>)pObject.get("effects"))).toArray(MobEffectInstance[]::new);
            return new AddEffectsFunction(pConditions, effects);
        }
    }
}

