/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import net.kapitencraft.kap_lib.event.custom.PlayerChangeManaEvent;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber
public class ManaHandler {
    @SubscribeEvent
    @ApiStatus.Internal
    public static void manaChange(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!ManaHandler.isMagical((LivingEntity)player)) {
            throw new IllegalStateException("detected Player unable to use mana, expecting broken mod-state!");
        }
        ManaHandler.growMana((LivingEntity)player, player.m_21133_((Attribute)ExtraAttributes.MANA_REGEN.get()));
    }

    public static boolean consumeMana(LivingEntity living, double manaToConsume) {
        if (!ManaHandler.hasMana(living, manaToConsume)) {
            return false;
        }
        double mana = ManaHandler.getMana(living);
        if (manaToConsume > 0.0) {
            mana -= manaToConsume;
        }
        ManaHandler.setMana(living, mana, PlayerChangeManaEvent.Reason.USAGE);
        return true;
    }

    public static boolean hasMana(LivingEntity living, double manaToConsume) {
        if (manaToConsume <= 0.0) {
            return true;
        }
        if (!ManaHandler.isMagical(living)) {
            return false;
        }
        double mana = ManaHandler.getMana(living);
        return mana >= manaToConsume;
    }

    public static double getMana(LivingEntity living) {
        return AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.MANA.get(), living);
    }

    public static void setMana(LivingEntity living, double mana, PlayerChangeManaEvent.Reason reason) {
        AttributeInstance instance = living.m_21051_((Attribute)ExtraAttributes.MANA.get());
        if (instance != null) {
            double manaValue = Math.min(mana, living.m_21133_((Attribute)ExtraAttributes.MAX_MANA.get()));
            if (living instanceof Player) {
                Player player = (Player)living;
                PlayerChangeManaEvent event = new PlayerChangeManaEvent(player, manaValue, reason);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    return;
                }
                manaValue = event.getNewMana();
            }
            instance.m_22100_(manaValue);
        }
    }

    private static void growMana(LivingEntity living, double mana) {
        ManaHandler.setMana(living, ManaHandler.getMana(living) + mana, PlayerChangeManaEvent.Reason.NATURAL);
    }

    public static boolean isMagical(LivingEntity living) {
        return living.m_21051_((Attribute)ExtraAttributes.MANA.get()) != null || living.m_21051_((Attribute)ExtraAttributes.MAX_MANA.get()) != null;
    }
}

