/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.kapitencraft.kap_lib.mixin.duck.attribute.IKapLibAttributeModifier;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaAttributeModifierTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class TimedModifier
extends AttributeModifier
implements IKapLibAttributeModifier {
    public static final Codec<TimedModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(AttributeModifier::m_22214_), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeModifier::m_22218_), (App)VanillaAttributeModifierTypes.OPERATION_CODEC.fieldOf("operation").forGetter(AttributeModifier::m_22217_), (App)Codec.INT.fieldOf("timer").forGetter(TimedModifier::remaining)).apply((Applicative)instance, TimedModifier::new));
    private int timer;

    public TimedModifier(String name, double value, AttributeModifier.Operation operation, int timer) {
        super(UUID.randomUUID(), name, value, operation);
        this.timer = timer;
    }

    private boolean tickDown() {
        return this.timer-- <= 0;
    }

    private int remaining() {
        return this.timer;
    }

    @Override
    public Codec<? extends AttributeModifier> getCodec() {
        return CODEC;
    }

    @Override
    public boolean tickBased() {
        return true;
    }

    @Override
    public boolean tick() {
        return this.tickDown();
    }
}

