/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import java.util.Objects;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.VisibleSpawner;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.client.util.rot_target.RotationTarget;
import net.kapitencraft.kap_lib.helpers.ExtraStreamCodecs;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class RingSpawner
extends VisibleSpawner {
    private final PositionTarget target;
    private final RotationTarget rotation;
    private float curRot;
    private float curHeightChange;
    private boolean rising;
    private final float rotPerTick;
    private final float maxHeight;
    private final float heightChangePerTick;
    private final float radius;
    private final float angleBetweenSpawner;
    private final int spawnerCount;
    private final Direction.Axis axis;

    private RingSpawner(PositionTarget target, ParticleOptions particle, RotationTarget rotation, Direction.Axis axis, float rotPerTick, float maxHeight, float heightChangePerTick, float radius, int spawnerCount) {
        super(particle);
        if (radius <= 0.0f) {
            throw new IllegalStateException("Ring-Spawner radius must be larger than 0!");
        }
        this.rotation = Objects.requireNonNull(rotation, "Ring-Spawner no rotation specified!");
        this.target = Objects.requireNonNull(target, "Ring-Spawner no target specified!");
        this.axis = Objects.requireNonNull(axis, "Ring-Spawner no axis specified");
        this.rotPerTick = rotPerTick;
        this.maxHeight = maxHeight;
        this.heightChangePerTick = heightChangePerTick;
        this.radius = radius;
        this.spawnerCount = spawnerCount;
        this.angleBetweenSpawner = 360.0f / (float)spawnerCount;
    }

    @NotNull
    public Type getType() {
        return SpawnerTypes.RING.get();
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        Vec2 rot = this.rotation.get();
        for (int i = 0; i < this.spawnerCount; ++i) {
            double sin = Math.sin(Math.toRadians(this.curRot + this.angleBetweenSpawner * (float)i)) * (double)this.radius;
            double cos = Math.cos(Math.toRadians(this.curRot + this.angleBetweenSpawner * (float)i)) * (double)this.radius;
            double x = this.axis == Direction.Axis.X ? 0.0 : sin;
            double y = switch (this.axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> sin;
                case Direction.Axis.Y -> 0.0;
                case Direction.Axis.Z -> cos;
            };
            double z = this.axis == Direction.Axis.Z ? 0.0 : cos;
            Vec3 targetOffset = new Vec3(x, y, z);
            switch (this.axis) {
                case X: {
                    targetOffset = MathHelper.rotateHorizontalYAxis(targetOffset, Vec3.ZERO, rot.x);
                    targetOffset = MathHelper.rotateZAxis(targetOffset, Vec3.ZERO, rot.y);
                    break;
                }
                case Y: {
                    targetOffset = MathHelper.rotateXAxis(targetOffset, Vec3.ZERO, rot.x);
                    targetOffset = MathHelper.rotateZAxis(targetOffset, Vec3.ZERO, rot.y);
                    break;
                }
                case Z: {
                    targetOffset = MathHelper.rotateXAxis(targetOffset, Vec3.ZERO, rot.x);
                    targetOffset = MathHelper.rotateHorizontalYAxis(targetOffset, Vec3.ZERO, rot.y);
                }
            }
            Vec3 targetPos = targetOffset.add(Vec3.ZERO.with(this.axis, (double)this.curHeightChange)).add(this.target.get());
            sink.accept(this.particle, targetPos);
            this.curRot += this.rotPerTick;
            if (!(this.heightChangePerTick > 0.0f)) continue;
            this.applyHeightChange();
        }
    }

    @ApiStatus.Internal
    private void applyHeightChange() {
        if (this.rising) {
            float distanceToMax = this.maxHeight - this.curHeightChange;
            if (distanceToMax < this.heightChangePerTick) {
                this.curHeightChange = this.maxHeight - (this.heightChangePerTick - distanceToMax);
                this.rising = false;
            } else {
                this.curHeightChange += this.heightChangePerTick;
            }
        } else if (this.curHeightChange < this.heightChangePerTick) {
            this.curHeightChange = this.heightChangePerTick - this.curHeightChange;
            this.rising = true;
        } else {
            this.curHeightChange -= this.heightChangePerTick;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder fullCircle(int spawnerCount) {
        return RingSpawner.noHeight().spawnCount(spawnerCount).rotPerTick(0.0f);
    }

    public static Builder noHeight() {
        return new Builder().maxHeight(0.0f).heightPerTick(0.0f);
    }

    public static Builder entityWithBBSize(Entity entity, float xScale, float yScale) {
        float bbRadius = entity.getBbWidth() / 2.0f;
        return RingSpawner.builder().setTarget(PositionTarget.entity(entity)).axis(Direction.Axis.Y).maxHeight(entity.getBbHeight() * yScale).radius(bbRadius * xScale);
    }

    public String toString() {
        return "RingSpawner{particle=" + String.valueOf(this.particle) + ", axis=" + String.valueOf(this.axis) + ", spawnerCount=" + this.spawnerCount + ", angleBetweenSpawner=" + this.angleBetweenSpawner + ", radius=" + this.radius + ", heightChangePerTick=" + this.heightChangePerTick + ", maxHeight=" + this.maxHeight + ", rotPerTick=" + this.rotPerTick + ", rising=" + this.rising + ", curHeightChange=" + this.curHeightChange + ", curRot=" + this.curRot + ", target=" + String.valueOf(this.target) + "}";
    }

    public static class Type
    implements Spawner.Type<RingSpawner> {
        private static final StreamCodec<RegistryFriendlyByteBuf, RingSpawner> STREAM_CODEC = ExtraStreamCodecs.composite(PositionTarget.STREAM_CODEC, s -> s.target, ParticleTypes.STREAM_CODEC, s -> s.particle, RotationTarget.CODEC, s -> s.rotation, ExtraStreamCodecs.enumCodec((Enum[])Direction.Axis.values()), s -> s.axis, ByteBufCodecs.FLOAT, s -> Float.valueOf(s.rotPerTick), ByteBufCodecs.FLOAT, s -> Float.valueOf(s.maxHeight), ByteBufCodecs.FLOAT, s -> Float.valueOf(s.heightChangePerTick), ByteBufCodecs.FLOAT, s -> Float.valueOf(s.radius), ByteBufCodecs.INT, s -> s.spawnerCount, RingSpawner::new);

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, RingSpawner> codec() {
            return STREAM_CODEC;
        }
    }

    public static class Builder
    extends VisibleSpawner.Builder<Builder> {
        private PositionTarget target;
        private float rotPerTick;
        private float maxHeight;
        private float heightChangePerTick;
        private float radius;
        private int spawnCount = 1;
        private Direction.Axis axis;
        private RotationTarget rotationTarget = RotationTarget.absolute(Vec2.ZERO);

        public Builder rotPerTick(float rotPerTick) {
            this.rotPerTick = rotPerTick;
            return this;
        }

        public Builder maxHeight(float maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public Builder heightPerTick(float heightChangePerTick) {
            this.heightChangePerTick = heightChangePerTick;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder spawnCount(int count) {
            this.spawnCount = count;
            return this;
        }

        public Builder axis(Direction.Axis axis) {
            this.axis = axis;
            return this;
        }

        public Builder setTarget(PositionTarget target) {
            this.target = target;
            return this;
        }

        public Builder rotation(RotationTarget target) {
            this.rotationTarget = target;
            return this;
        }

        @Override
        public VisibleSpawner build() {
            return new RingSpawner(this.target, this.particle, this.rotationTarget, this.axis, this.rotPerTick, this.maxHeight, this.heightChangePerTick, this.radius, this.spawnCount);
        }
    }
}

