/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Queue<T> {
    private final List<T> active = new ArrayList<T>();
    private final List<T> queue = new ArrayList<T>();
    private final List<T> removeQueue = new ArrayList<T>();
    private boolean queuing = false;

    private Queue() {
    }

    public static <T> Queue<T> create() {
        return new Queue<T>();
    }

    public void add(T obj) {
        if (this.queuing) {
            this.queue.add(obj);
        } else {
            this.active.add(obj);
        }
    }

    public void startQueuing() {
        this.queuing = true;
    }

    public void stopQueuing() {
        this.active.addAll(this.queue);
        this.active.removeAll(this.removeQueue);
        this.queue.clear();
        this.removeQueue.clear();
        this.queuing = false;
    }

    public void remove(T obj) {
        if (this.queuing) {
            this.removeQueue.add(obj);
        } else {
            this.active.remove(obj);
        }
    }

    public void queue(Consumer<T> consumer) {
        this.ensureReady();
        this.startQueuing();
        this.active.forEach(consumer);
        this.stopQueuing();
    }

    public List<T> getAll() {
        this.ensureReady();
        return this.active;
    }

    private void ensureReady() {
        if (this.queuing) {
            throw new IllegalStateException("can not get elements while queuing!");
        }
    }
}

