/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes;

import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ExtraMobEffects;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.ILivingEntityExtension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ILivingEntityExtension {
    @Shadow
    @Final
    private AttributeMap attributes;

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    public LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"updateFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkRequirements(CallbackInfo ci) {
        if (!this.level().isClientSide() && !RequirementManager.instance.meetsRequirements(RegistryReqType.ITEM, this.getItemBySlot(EquipmentSlot.CHEST).getItem(), this.self())) {
            this.setSharedFlag(7, false);
            ci.cancel();
        }
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtArmor(Lnet/minecraft/world/damagesource/DamageSource;F)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void getDamageAfterArmorAbsorb(DamageSource source, float damage, CallbackInfoReturnable<Float> cir) {
        double d;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            d = AttributeHelper.getSaveAttributeValue(ExtraAttributes.ARMOR_SHREDDER, living);
        } else {
            d = 0.0;
        }
        double armorShredValue = d;
        double armorValue = Math.max(0.0, this.getArmorValue(source) - armorShredValue);
        cir.setReturnValue((Object)Float.valueOf(MathHelper.calculateDamage(damage, (float)armorValue, (float)this.self().getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
    }

    @Unique
    private double getArmorValue(DamageSource source) {
        if (source.getMsgId().equals("true_damage")) {
            return AttributeHelper.getSaveAttributeValue(ExtraAttributes.TRUE_DEFENCE, this.self());
        }
        return AttributeHelper.getSaveAttributeValue((Holder<Attribute>)Attributes.ARMOR, this.self());
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN", ordinal=6)})
    public void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        LivingEntity living;
        double attackSpeed;
        Entity entity;
        if (source.getEntity() != null && (entity = source.getEntity()) instanceof LivingEntity && (attackSpeed = AttributeHelper.getSaveAttributeValue(ExtraAttributes.BONUS_ATTACK_SPEED, living = (LivingEntity)entity)) > 0.0) {
            this.self().invulnerableTime = (int)(20.0 - attackSpeed * 0.15);
        }
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD")}, cancellable=true)
    private void addStunEffect(CallbackInfoReturnable<Boolean> cir) {
        if (this.hasEffect(ExtraMobEffects.STUN)) {
            cir.setReturnValue((Object)true);
        }
    }
}

