/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay.box;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.gui.IMenuBuilder;
import net.kapitencraft.kap_lib.client.overlay.OverlayController;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.box.ResizeAccessBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.client.widget.menu.Menu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.ButtonElement;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.EnumElement;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;

public class ResizeBox
extends ResizeAccessBox
implements IMenuBuilder {
    private final List<ResizeAccessBox> boxes = new ArrayList<ResizeAccessBox>();
    private static final int boxColor = -1;
    private static final int fillColor = 0x30FFFFFF;
    private ResizeAccessBox active;
    private boolean dirty = false;

    public ResizeBox(Vec2 start, Vec2 finish, Overlay dedicatedHolder) {
        super(start, finish, 221193, 0x30FFFFFF, dedicatedHolder, Type.C, null);
        this.fillBoxes();
    }

    private void fillBoxes() {
        this.boxes.clear();
        for (Type type : Type.values()) {
            if (type == Type.C) continue;
            this.boxes.add(new ResizeAccessBox(-1, this.dedicatedHolder, type, this));
        }
        this.reapplyPosition();
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY) {
        if (this.dirty) {
            this.reapplyPosition();
            this.dirty = false;
        }
        super.render(graphics, mouseX, mouseY);
        this.boxes.forEach(resizeAccessBox -> resizeAccessBox.render(graphics, mouseX, mouseY));
    }

    @Override
    public int getCursorType(double mouseX, double mouseY) {
        return this.boxes.stream().filter(resizeAccessBox -> resizeAccessBox.m_5953_(mouseX, mouseY)).map(box -> box.getCursorType(mouseX, mouseY)).findFirst().orElse(this.getSelfCursor(mouseX, mouseY));
    }

    private int getSelfCursor(double mouseX, double mouseY) {
        int cursorId = 221185;
        if (this.m_5953_(mouseX, mouseY)) {
            cursorId = 221193;
        }
        return cursorId;
    }

    @Override
    public void move(Vec2 delta) {
        this.dedicatedHolder.move(delta);
        this.moveWithoutHolder(delta);
    }

    private void moveWithoutHolder(Vec2 delta) {
        super.move(delta);
        this.boxes.forEach(resizeAccessBox -> resizeAccessBox.move(delta));
    }

    @Override
    protected void reapplyPosition() {
        this.boxes.forEach(ResizeAccessBox::reapplyPosition);
    }

    private void synchronizePosition() {
        float width = ClientHelper.getScreenWidth();
        float height = ClientHelper.getScreenHeight();
        Vec2 pos = this.dedicatedHolder.getLoc(width, height);
        Vec2 move = pos.m_165910_(this.start.m_165903_(-1.0f));
        this.moveWithoutHolder(move);
    }

    @Override
    public boolean m_5953_(double x, double y) {
        return super.m_5953_(x, y) || this.boxes.stream().anyMatch(resizeAccessBox -> resizeAccessBox.m_5953_(x, y));
    }

    @Override
    public boolean mouseDrag(double x, double y, int clickType, double xChange, double yChange, double oldX, double oldY) {
        if (this.active == null) {
            boolean[] flag = new boolean[]{false};
            this.boxes.stream().filter(resizeAccessBox -> resizeAccessBox.m_5953_(oldX, oldY)).findFirst().ifPresentOrElse(this::setActive, () -> {
                if (this.m_5953_(oldX, oldY)) {
                    this.setActive(this);
                    flag[0] = true;
                }
            });
            return flag[0];
        }
        if (this.active == this) {
            this.move(new Vec2((float)xChange, (float)yChange));
        } else {
            float width = this.width();
            float height = this.height();
            float scaleX = (float)(((double)width + xChange) / (double)width);
            float scaleY = (float)(((double)height + yChange) / (double)height);
            this.scale(scaleX, scaleY);
        }
        this.dirty = true;
        return true;
    }

    @Override
    public void scale(float x, float y) {
        float height = this.height();
        float width = this.width();
        float xChange = width * x - width;
        float yChange = height * x - height;
        Map<Axis, Boolean> map = this.getTypeAxes();
        if (map.containsKey((Object)Axis.X) && map.get((Object)Axis.X).booleanValue()) {
            this.dedicatedHolder.move(new Vec2(xChange *= -1.0f, 0.0f));
        }
        if (map.containsKey((Object)Axis.Y) && map.get((Object)Axis.Y).booleanValue()) {
            this.dedicatedHolder.move(new Vec2(0.0f, yChange *= -1.0f));
        }
        this.reapplyPosition(new Vec2(xChange, yChange));
        super.scale(x, y);
    }

    private void reapplyPosition(Vec2 change) {
        Map<Axis, Boolean> map = this.getTypeAxes();
        if (map.containsKey((Object)Axis.X)) {
            if (map.get((Object)Axis.X).booleanValue()) {
                this.start = this.start.m_165910_(new Vec2(change.f_82470_, 0.0f));
            } else {
                this.finish = this.finish.m_165910_(new Vec2(change.f_82470_, 0.0f));
            }
        }
        if (map.containsKey((Object)Axis.Y)) {
            if (map.get((Object)Axis.Y).booleanValue()) {
                this.start = this.start.m_165910_(new Vec2(0.0f, change.f_82471_));
            } else {
                this.finish = this.finish.m_165910_(new Vec2(0.0f, change.f_82471_));
            }
        }
        this.reapplyPosition();
    }

    private Map<Axis, Boolean> getTypeAxes() {
        return this.getType().axes;
    }

    @Override
    protected Type getType() {
        return this.active.getType();
    }

    @Override
    public void mouseRelease(double x, double y) {
        this.active = null;
    }

    private void setActive(ResizeAccessBox box) {
        this.active = box;
    }

    @Override
    public Menu createMenu(int x, int y) {
        if (this.dedicatedHolder == null) {
            return null;
        }
        DropDownMenu menu = new DropDownMenu(x, y, this);
        OverlayProperties properties = this.dedicatedHolder.getProperties();
        menu.addElement(((EnumElement.Builder)EnumElement.builder(OverlayProperties.Alignment.class).setName((Component)Component.m_237115_((String)"gui.alignment.x"))).setElements(OverlayProperties.Alignment.values()).setNameMapper(OverlayProperties.Alignment::getWidthName).setOnChange(properties::setXAlignment));
        menu.addElement(((EnumElement.Builder)EnumElement.builder(OverlayProperties.Alignment.class).setName((Component)Component.m_237115_((String)"gui.alignment.y"))).setElements(OverlayProperties.Alignment.values()).setNameMapper(OverlayProperties.Alignment::getHeightName).setOnChange(properties::setYAlignment));
        menu.addElement(((ButtonElement.Builder)ButtonElement.builder().setName((Component)Component.m_237115_((String)"gui.reset_overlay"))).setExecutor(this::reset));
        menu.addElement(((ButtonElement.Builder)ButtonElement.builder().setName((Component)Component.m_237115_((String)"gui.hide_overlay"))).setExecutor(properties::hide));
        return menu;
    }

    private void reset() {
        OverlayController controller = LibClient.controller;
        controller.reset(this.dedicatedHolder);
        this.synchronizePosition();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return pButton == 1 && this.m_5953_(pMouseX, pMouseY);
    }

    public static enum Type {
        N(Map.of(Axis.Y, true)),
        NE(Map.of(Axis.Y, true, Axis.X, false)),
        E(Map.of(Axis.X, false)),
        SE(Map.of(Axis.Y, false, Axis.X, false)),
        S(Map.of(Axis.Y, false)),
        SW(Map.of(Axis.Y, false, Axis.X, true)),
        W(Map.of(Axis.X, true)),
        NW(Map.of(Axis.Y, true, Axis.X, false)),
        C(Map.of());

        private final Map<Axis, Boolean> axes;

        private Type(Map<Axis, Boolean> map) {
            this.axes = map;
        }
    }

    private static enum Axis {
        X,
        Y;

    }
}

