/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay.holder;

import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.box.ResizeBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;

public abstract class Overlay {
    private final OverlayProperties properties;
    private Component name;

    public Overlay(OverlayProperties holder) {
        this.properties = holder;
    }

    public Vec2 getLoc(float screenWidth, float screenHeight) {
        return this.properties.getLoc(screenWidth, screenHeight);
    }

    public void move(Vec2 toAdd) {
        this.properties.add(toAdd);
    }

    protected void renderString(GuiGraphics graphics, Component toWrite, float y) {
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, toWrite, 0, (int)y, -1);
    }

    public ResizeBox newBox(float screenWidth, float screenHeight, LocalPlayer player, Font font) {
        Vec2 loc = this.getLoc(screenWidth, screenHeight);
        float width = this.getWidth(player, font) * this.properties.getXScale();
        float height = this.getHeight(player, font) * this.properties.getYScale();
        return new ResizeBox(loc.m_165910_(new Vec2(-1.0f, -2.0f)), loc.m_165910_(new Vec2(width + 1.0f, height)), this);
    }

    public abstract float getWidth(LocalPlayer var1, Font var2);

    public abstract float getHeight(LocalPlayer var1, Font var2);

    public abstract void render(GuiGraphics var1, float var2, float var3, LocalPlayer var4);

    public OverlayProperties getProperties() {
        return this.properties;
    }

    public boolean isVisible() {
        return this.properties.isVisible();
    }

    public void setVisible(Boolean b) {
        this.properties.setVisible(b);
    }

    public Component getName() {
        return this.name;
    }
}

