/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.ClientData;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimationController;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleAnimationAcceptor {
    private final List<ParticleAnimationController> controllers = new ArrayList<ParticleAnimationController>();

    public void addAnimation(ParticleAnimationController controller) {
        this.controllers.add(controller);
    }

    public void animateAll() {
        int time = ClientData.getTime();
        this.controllers.removeIf(controller -> {
            if (controller.isDone()) {
                return true;
            }
            if (controller.startTime == -1) {
                controller.startTime = time;
            }
            int activeTime = time - controller.startTime;
            controller.animate(activeTime);
            return controller.done(activeTime);
        });
    }
}

