/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.client.BannerPatternRenderer;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.widget.MultiElementSelectorWidget;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class CreateBannerWidget
extends PositionedWidget {
    private static final List<DyeColor> lights = List.of(DyeColor.WHITE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.LIGHT_BLUE);
    private final List<PositionedWidget> widgets = new ArrayList<PositionedWidget>();
    private final VisualPatternBuilder builder;
    private final SelectDyeColorWidget selectDyeColorWidget;

    public CreateBannerWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.selectDyeColorWidget = new SelectDyeColorWidget(this.x + 1, this.y + 1, 2, height);
        this.widgets.add(this.selectDyeColorWidget);
        int xStart1 = this.x + 2 + this.selectDyeColorWidget.width;
        SelectBannerPatternWidget selectBannerPatternWidget = new SelectBannerPatternWidget(xStart1, this.y + 1, 4, height);
        this.widgets.add(selectBannerPatternWidget);
        this.builder = new VisualPatternBuilder(xStart1 + 57, this.y + 1, height, List.of());
        this.widgets.add(this.builder);
    }

    public ItemStack getBanner() {
        return this.builder.createBanner();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.widgets.forEach(positionedWidget -> positionedWidget.m_88315_(graphics, pMouseX, pMouseY, pPartialTick));
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        return this.widgets.stream().anyMatch(positionedWidget -> positionedWidget.m_6050_(pMouseX, pMouseY, pDelta));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return this.widgets.stream().anyMatch(positionedWidget -> positionedWidget.m_6375_(pMouseX, pMouseY, pButton));
    }

    private static class SelectDyeColorWidget
    extends MultiElementSelectorWidget<DyeColor> {
        public SelectDyeColorWidget(int x, int y, int width, int height) {
            super(x, y, width, 16, height, List.of(DyeColor.values()));
            this.active = DyeColor.WHITE;
        }

        @Override
        protected void createElement(Consumer<MultiElementSelectorWidget.ElementButton> adder, int xStart, int yStart, int elementSize, DyeColor element) {
            adder.accept(new MultiElementSelectorWidget.ElementButton(this, xStart, yStart, 16, element, new Color(element.m_41071_()).setAlpha(255.0f).pack()));
        }
    }

    private class SelectBannerPatternWidget
    extends MultiElementSelectorWidget<Holder<BannerPattern>> {
        public SelectBannerPatternWidget(int x, int y, int width, int height) {
            super(x, y, width, 14, height, SelectBannerPatternWidget.getElements());
            this.active = null;
        }

        private static List<Holder<BannerPattern>> getElements() {
            Iterator patterns = BuiltInRegistries.f_256878_.m_206115_().iterator();
            ArrayList<Holder<BannerPattern>> list = new ArrayList<Holder<BannerPattern>>();
            while (patterns.hasNext()) {
                list.add((Holder<BannerPattern>)((Holder)patterns.next()));
            }
            return list;
        }

        @Override
        protected void createElement(Consumer<MultiElementSelectorWidget.ElementButton> adder, int xStart, int yStart, int elementSize, Holder<BannerPattern> element) {
            adder.accept(new Element(xStart, yStart, element));
        }

        private class Element
        extends MultiElementSelectorWidget.ElementButton {
            private final ModelPart flag;

            protected Element(int x, int y, Holder<BannerPattern> own) {
                super(SelectBannerPatternWidget.this, x, y, 14, own, -1);
                this.flag = BannerPatternRenderer.getFlag();
            }

            @Override
            public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                boolean flag = this.hovered(pMouseX, pMouseY);
                int j2 = 166;
                if (this.own == SelectBannerPatternWidget.this.active) {
                    j2 += 14;
                } else if (flag) {
                    j2 += 28;
                }
                int xOffset = this.getXOffset();
                int yOffset = this.getYOffset();
                graphics.m_280218_(UsefulTextures.SLIDER, xOffset, yOffset, 0, j2, 14, 14);
                this.renderPattern((DyeColor)CreateBannerWidget.this.selectDyeColorWidget.active);
            }

            @Override
            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                if (this.hovered(pMouseX, pMouseY)) {
                    CreateBannerWidget widget = CreateBannerWidget.this;
                    if (((Holder)this.own).get() == BuiltInRegistries.f_256878_.m_6246_(BannerPatterns.f_222726_)) {
                        widget.builder.background = (DyeColor)widget.selectDyeColorWidget.active;
                        return true;
                    }
                    return widget.builder.addPattern((Holder<BannerPattern>)((Holder)this.own), (DyeColor)widget.selectDyeColorWidget.active);
                }
                return false;
            }

            @Contract(value="null -> fail")
            private void renderPattern(DyeColor color) {
                CompoundTag compoundtag = new CompoundTag();
                ListTag listtag = new BannerPattern.Builder().m_222705_(BannerPatterns.f_222726_, lights.contains(color) ? DyeColor.GRAY : DyeColor.WHITE).m_222708_((Holder)this.own, color).m_58587_();
                compoundtag.m_128365_("Patterns", (Tag)listtag);
                ItemStack itemstack = new ItemStack((ItemLike)(lights.contains(color) ? Items.f_42667_ : Items.f_42660_));
                BlockItem.m_186338_((ItemStack)itemstack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)compoundtag);
                PoseStack posestack = new PoseStack();
                posestack.m_85836_();
                posestack.m_252880_((float)this.getXOffset() + 0.5f, (float)(this.getYOffset() + 16), 0.0f);
                posestack.m_85841_(6.0f, -6.0f, 1.0f);
                posestack.m_252880_(0.5f, 0.5f, 0.0f);
                posestack.m_252880_(0.5f, 0.5f, 0.0f);
                float f = 0.6666667f;
                posestack.m_85841_(f, -f, -f);
                MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
                List list = BannerBlockEntity.m_58484_((DyeColor)DyeColor.GRAY, (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemstack));
                BannerRenderer.m_112065_((PoseStack)posestack, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.f_118083_, (ModelPart)this.flag, (Material)ModelBakery.f_119224_, (boolean)true, (List)list);
                posestack.m_85849_();
                source.m_109911_();
            }
        }
    }

    private static class VisualPatternBuilder
    extends MultiElementSelectorWidget<Pair<Holder<BannerPattern>, DyeColor>> {
        private final ModelPart flag = BannerPatternRenderer.getFlag();
        private DyeColor background = DyeColor.WHITE;
        private int ySpawnOffset = 0;

        public VisualPatternBuilder(int x, int y, int height, List<Pair<Holder<BannerPattern>, DyeColor>> elements) {
            super(x, y, 1, 14, height, elements);
        }

        public boolean addPattern(Holder<BannerPattern> pBannerPattern, DyeColor pColor) {
            return this.addPattern((Pair<Holder<BannerPattern>, DyeColor>)Pair.of(pBannerPattern, (Object)pColor));
        }

        public boolean addPattern(Pair<Holder<BannerPattern>, DyeColor> pPattern) {
            if (this.buttons.size() == 17) {
                return false;
            }
            this.buttons.add(new PatternElement(this.x, this.y + this.ySpawnOffset, pPattern));
            this.ySpawnOffset += 14;
            this.allElementsSize += 14;
            return true;
        }

        public boolean movePattern(@Range(from=0L, to=0x7FFFFFFFL) int moveIndex, boolean up) {
            if (this.buttons.isEmpty() || up && moveIndex == 0 || !up && moveIndex + 1 == this.buttons.size()) {
                return false;
            }
            PatternElement pattern = (PatternElement)this.buttons.remove(moveIndex);
            if (up) {
                this.buttons.add(--moveIndex, pattern);
            } else {
                this.buttons.add(++moveIndex, pattern);
            }
            this.reapplyYPos();
            return true;
        }

        public void removePattern(int removeLoc) {
            this.buttons.remove(removeLoc);
            this.ySpawnOffset -= 14;
        }

        private void moveAllUp(int startId, int endId) {
            for (int i = startId; i <= endId; ++i) {
                this.moveUp(i);
            }
        }

        private void moveUp(int elementId) {
            ((MultiElementSelectorWidget.ElementButton)this.buttons.get(elementId)).move(-14);
        }

        private void reapplyYPos() {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ((MultiElementSelectorWidget.ElementButton)this.buttons.get((int)i)).y = this.y + i * 14;
            }
        }

        @Override
        protected void createElement(Consumer<MultiElementSelectorWidget.ElementButton> adder, int xStart, int yStart, int elementSize, Pair<Holder<BannerPattern>, DyeColor> element) {
            adder.accept(new PatternElement(this.x, this.y, element));
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
            ArrayList<Pair<Holder<BannerPattern>, DyeColor>> arrayList = new ArrayList<Pair<Holder<BannerPattern>, DyeColor>>(this.bakePatterns());
            arrayList.add(0, (Pair<Holder<BannerPattern>, DyeColor>)Pair.of((Object)BuiltInRegistries.f_256878_.m_246971_(BannerPatterns.f_222726_), (Object)this.background));
            BannerPatternRenderer.renderBanner(graphics, this.x + 10, this.y + 1, arrayList, this.height - 2);
        }

        private List<Pair<Holder<BannerPattern>, DyeColor>> bakePatterns() {
            return this.buttons.stream().map(elementButton -> (Pair)elementButton.own).toList();
        }

        @Contract(value="null, _, _, _ -> fail; _, _, _, null -> fail")
        private void renderPattern(Holder<BannerPattern> pPattern, int pX, int pY, DyeColor color) {
            CompoundTag compoundtag = new CompoundTag();
            ListTag listtag = new BannerPattern.Builder().m_222705_(BannerPatterns.f_222726_, lights.contains(color) ? DyeColor.GRAY : DyeColor.WHITE).m_222708_(pPattern, color).m_58587_();
            compoundtag.m_128365_("Patterns", (Tag)listtag);
            ItemStack itemstack = new ItemStack((ItemLike)(lights.contains(color) ? Items.f_42667_ : Items.f_42660_));
            BlockItem.m_186338_((ItemStack)itemstack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)compoundtag);
            PoseStack posestack = new PoseStack();
            posestack.m_85836_();
            posestack.m_252880_((float)pX + 0.5f, (float)(pY + 16), 0.0f);
            posestack.m_85841_(6.0f, -6.0f, 1.0f);
            posestack.m_252880_(0.5f, 0.5f, 0.0f);
            posestack.m_252880_(0.5f, 0.5f, 0.0f);
            float f = 0.6666667f;
            posestack.m_85841_(f, -f, -f);
            MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
            List list = BannerBlockEntity.m_58484_((DyeColor)DyeColor.GRAY, (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemstack));
            BannerRenderer.m_112065_((PoseStack)posestack, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.f_118083_, (ModelPart)this.flag, (Material)ModelBakery.f_119224_, (boolean)true, (List)list);
            posestack.m_85849_();
            source.m_109911_();
        }

        public ItemStack createBanner() {
            ItemStack stack = new ItemStack((ItemLike)VisualPatternBuilder.getBannerItem(this.background));
            CompoundTag compoundTag = new CompoundTag();
            BannerPattern.Builder builder = new BannerPattern.Builder();
            this.bakePatterns().forEach(arg_0 -> ((BannerPattern.Builder)builder).m_155048_(arg_0));
            compoundTag.m_128365_("Patterns", (Tag)builder.m_58587_());
            stack.m_41751_(compoundTag);
            return stack;
        }

        private static Item getBannerItem(DyeColor color) {
            return switch (color) {
                default -> throw new IncompatibleClassChangeError();
                case DyeColor.LIME -> Items.f_42665_;
                case DyeColor.YELLOW -> Items.f_42664_;
                case DyeColor.WHITE -> Items.f_42660_;
                case DyeColor.RED -> Items.f_42727_;
                case DyeColor.BLACK -> Items.f_42728_;
                case DyeColor.BLUE -> Items.f_42671_;
                case DyeColor.CYAN -> Items.f_42669_;
                case DyeColor.GRAY -> Items.f_42667_;
                case DyeColor.PINK -> Items.f_42666_;
                case DyeColor.BROWN -> Items.f_42672_;
                case DyeColor.GREEN -> Items.f_42673_;
                case DyeColor.ORANGE -> Items.f_42661_;
                case DyeColor.PURPLE -> Items.f_42670_;
                case DyeColor.MAGENTA -> Items.f_42662_;
                case DyeColor.LIGHT_BLUE -> Items.f_42663_;
                case DyeColor.LIGHT_GRAY -> Items.f_42668_;
            };
        }

        private class PatternElement
        extends MultiElementSelectorWidget.ElementButton {
            protected PatternElement(int x, int y, Pair<Holder<BannerPattern>, DyeColor> own) {
                super(VisualPatternBuilder.this, x, y, 14, own, -1);
            }

            @Override
            public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)UsefulTextures.SLIDER);
                boolean flag = MathHelper.is2dBetween(pMouseX, pMouseY, this.x, this.y, this.x + 14, this.y + 14);
                int j2 = 166;
                if (flag) {
                    j2 += 28;
                }
                int xOffset = this.getXOffset();
                int yOffset = this.getYOffset();
                graphics.m_280218_(UsefulTextures.SLIDER, xOffset, yOffset, 0, j2, 14, 14);
                VisualPatternBuilder.this.renderPattern((Holder<BannerPattern>)((Holder)((Pair)this.own).getFirst()), xOffset, yOffset, (DyeColor)((Pair)this.own).getSecond());
                if (flag) {
                    UsefulTextures.renderCross(graphics, xOffset, yOffset + 7, 7);
                    int index = VisualPatternBuilder.this.buttons.indexOf(this);
                    if (index != 0) {
                        UsefulTextures.renderUpButton(graphics, xOffset + 7, yOffset, MathHelper.is2dBetween(pMouseX, pMouseY, this.x + 7, this.y, this.x + 14, this.y + 7), 7);
                    }
                    if (index != VisualPatternBuilder.this.buttons.size() - 1) {
                        UsefulTextures.renderDownButton(graphics, xOffset + 7, yOffset + 7, MathHelper.is2dBetween(pMouseX, pMouseY, this.x + 7, this.y + 7, this.x + 14, this.y + 14), 7);
                    }
                }
            }

            @Override
            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                if (this.hovered(pMouseX, pMouseY)) {
                    double relativeX = pMouseX - (double)this.x;
                    double relativeY = pMouseY - (double)this.y;
                    List list = VisualPatternBuilder.this.buttons;
                    int index = list.indexOf(this);
                    if (relativeX < 7.0) {
                        if (relativeY >= 7.0) {
                            VisualPatternBuilder.this.removePattern(index);
                            VisualPatternBuilder.this.moveAllUp(index, list.size() - 1);
                        }
                    } else {
                        boolean ignored = VisualPatternBuilder.this.movePattern(index, relativeY < 7.0);
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

