/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements;

import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.ListElement;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.StringRepresentable;

public abstract class Element
implements Renderable {
    private static final int BACKGROUND_COLOR = -16185079;
    private static final int FOCUS_COLOR = -8421505;
    public static final int OFFSET_PER_ELEMENT = 10;
    protected static final Font font = Minecraft.m_91087_().f_91062_;
    protected final ListElement parent;
    protected final DropDownMenu menu;
    private final Component name;
    protected int x;
    protected int y;
    protected boolean shown = false;
    protected boolean focused = false;

    protected Element(ListElement parent, DropDownMenu menu, Component name) {
        this.parent = parent;
        this.menu = menu;
        this.name = name;
    }

    public final void renderWithBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.parent != null) {
            int maxX = this.x + this.effectiveWidth();
            int maxY = this.y + 10;
            switch (ClientModConfig.getFocusType()) {
                case OUTLINE: {
                    if (this.focused) {
                        graphics.m_280509_(this.x, this.y, maxX, maxY, -8421505);
                    }
                    graphics.m_280509_(this.focused ? this.x + 1 : this.x, this.focused ? this.y + 1 : this.y, this.focused ? maxX - 1 : maxX, this.focused ? maxY - 1 : maxY, -16185079);
                    break;
                }
                case BACKGROUND: {
                    graphics.m_280509_(this.x, this.y, maxX, maxY, this.focused ? -8421505 : -16185079);
                }
            }
            graphics.m_280430_(font, this.name, this.x + 1, this.y + 1, -1);
        }
        this.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void show(int x, int y) {
        if (this.shown) {
            throw new IllegalStateException("tried showing Element that's already shown!");
        }
        this.x = x;
        this.y = y;
        this.shown = true;
    }

    public void hide() {
        this.shown = false;
    }

    public abstract void click(float var1, float var2);

    public void startHovering(int x, int y) {
        this.focused = true;
    }

    public void endHovering() {
        this.focused = false;
    }

    protected int width() {
        return font.m_92852_((FormattedText)this.name);
    }

    protected int effectiveWidth() {
        return this.parent == null ? 0 : this.parent.childrenWidth() + 2;
    }

    public void mouseMove(double mouseX, double mouseY) {
        this.onHover(mouseX, mouseY, true, () -> {
            if (!this.isFocused()) {
                this.startHovering((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y));
            }
        }, this::endHovering);
    }

    private void onHover(double mouseX, double mouseY, boolean includeChildren, Runnable ifHovered, Runnable onNotHovered) {
        ListElement listElement;
        Element element;
        double relativeX = mouseX - (double)this.x;
        double relativeY = mouseY - (double)this.y;
        if (relativeX >= 0.0 && relativeY >= 0.0 && relativeX <= (double)this.effectiveWidth() && relativeY <= 10.0) {
            ifHovered.run();
        } else if (!(!this.isFocused() || includeChildren && (element = this) instanceof ListElement && (listElement = (ListElement)element).isChildrenFocused())) {
            onNotHovered.run();
        }
    }

    public boolean mouseClick(double mouseX, double mouseY) {
        Element element = this.getFocused();
        if (element == null) {
            return false;
        }
        float relativeX = (float)(mouseX - (double)this.x);
        float relativeY = (float)(mouseY - (double)this.y);
        element.click(relativeX, relativeY);
        return true;
    }

    protected Element getFocused() {
        return this.isFocused() ? this : null;
    }

    protected boolean isFocused() {
        return this.focused;
    }

    public static enum FocusTypes implements StringRepresentable
    {
        OUTLINE("outline"),
        BACKGROUND("background");

        private final String serializedName;

        private FocusTypes(String serializedName) {
            this.serializedName = serializedName;
        }

        public String m_7912_() {
            return this.serializedName;
        }
    }

    public static abstract class Builder<T extends Element, I extends Builder<T, I>> {
        protected Component name;

        public I setName(Component name) {
            this.name = name;
            return (I)this;
        }

        public abstract T build(ListElement var1, DropDownMenu var2);
    }
}

