/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.requirements.RequirementType;
import net.kapitencraft.kap_lib.requirements.type.abstracts.ReqCondition;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class RequirementProvider<T>
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final RequirementType<T> type;
    private final Map<T, ReqCondition<?>> requirements = new HashMap();

    protected RequirementProvider(PackOutput output, String modId, RequirementType<T> type) {
        this.output = output;
        this.modId = modId;
        this.type = type;
    }

    protected void add(T element, ReqCondition<?> condition) {
        this.requirements.put(element, condition);
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput pOutput) {
        this.register();
        if (!this.requirements.isEmpty()) {
            return this.save(pOutput, this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("requirements").resolve(this.type.getName() + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        this.requirements.forEach((t, condition) -> {
            ResourceLocation elementId = this.type.getReg().getKey(t);
            if (elementId == null) {
                KapLibMod.LOGGER.warn(Markers.REQUIREMENTS_MANAGER, "could not find element {} in registry '{}'; skipping!", (Object)t.getClass().getCanonicalName(), (Object)this.type.getReg().getRegistryName());
                return;
            }
            json.add(elementId.toString(), condition.saveToJson());
        });
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    protected abstract void register();

    @NotNull
    public String m_6055_() {
        return this.modId + "-" + this.type.getName() + "-Requirements";
    }
}

