/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.abstracts;

import net.kapitencraft.kap_lib.enchantments.abstracts.ExtendedCalculationEnchantment;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public abstract class EffectApplicationEnchantment
extends ExtendedCalculationEnchantment {
    protected EffectApplicationEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots, ExtendedCalculationEnchantment.CalculationType type) {
        super(rarity, category, slots, type, ExtendedCalculationEnchantment.ProcessPriority.LOWEST);
    }

    protected abstract MobEffect getEffect();

    protected abstract int getChance(int var1);

    protected abstract int getScale();

    @Override
    public double execute(int level, ItemStack enchanted, LivingEntity attacker, LivingEntity attacked, double damage, DamageSource source) {
        if (!MiscHelper.increaseEffectDuration(attacked, this.getEffect(), level * this.getScale()) && MathHelper.chance((double)this.getChance(level) / 100.0, attacker)) {
            attacked.m_7292_(new MobEffectInstance(this.getEffect(), level * this.getScale(), 1));
        }
        return damage;
    }

    public String[] getDescriptionMods(int level) {
        return new String[]{this.getChance(level) + "%", "" + level * this.getScale()};
    }
}

