/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.BiFunction;
import net.kapitencraft.kap_lib.commands.OverlaysCommand;
import net.kapitencraft.kap_lib.commands.TestCommand;
import net.kapitencraft.kap_lib.config.ServerModConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface CommandHelper {
    @ApiStatus.Internal
    public static void registerClient(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        OverlaysCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        TestCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    public static void sendSuccess(CommandSourceStack stack, String msg, Object ... args) {
        stack.m_288197_(() -> Component.m_237110_((String)msg, (Object[])args).m_130940_(ChatFormatting.GREEN), true);
    }

    public static int checkNonConsoleCommand(CommandContext<CommandSourceStack> context, BiFunction<@NotNull ServerPlayer, CommandSourceStack, Integer> function) {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        if (stack.m_230896_() != null) {
            return function.apply(stack.m_230896_(), stack);
        }
        stack.m_81352_((Component)Component.m_237115_((String)"command.failed.console").m_130940_(ChatFormatting.RED));
        return 0;
    }

    public static boolean isModerator(CommandSourceStack stack) {
        return stack.m_6761_(1);
    }

    public static boolean isGameMaster(CommandSourceStack stack) {
        return stack.m_6761_(2);
    }

    public static boolean isAdmin(CommandSourceStack stack) {
        return stack.m_6761_(3);
    }

    public static boolean isOwner(CommandSourceStack stack) {
        return stack.m_6761_(4);
    }

    public static boolean isSocialEnabled(CommandSourceStack stack) {
        return ServerModConfig.areSocialCommandsEnabled();
    }
}

