/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.network.request;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.io.network.request.IRequestable;
import net.kapitencraft.kap_lib.io.network.request.RequestDataPacket;
import net.kapitencraft.kap_lib.io.network.request.RequestPacket;
import net.kapitencraft.kap_lib.registry.custom.ModRegistries;

public class RequestHandler {
    private final Map<Short, Consumer<?>> requests = new HashMap();
    private short nextEmpty = 0;
    private final Consumer<RequestPacket<?, ?>> packetDistributor;

    public RequestHandler(Consumer<RequestPacket<?, ?>> packetDistributor) {
        this.packetDistributor = packetDistributor;
    }

    public synchronized <T, K> void createRequest(IRequestable<T, K> requestable, K value, Consumer<T> consumer) {
        try {
            RequestPacket<T, K> packet = new RequestPacket<T, K>(this.nextEmpty, requestable, value);
            this.packetDistributor.accept(packet);
            this.requests.put(this.nextEmpty, consumer);
            this.nextEmpty = this.getNextEmpty(this.nextEmpty);
        }
        catch (Exception e) {
            KapLibMod.LOGGER.warn(Markers.REQUESTS, "unable to send request of type '{}': {}", (Object)ModRegistries.REQUESTABLES.getKey(requestable), (Object)e.getMessage());
        }
    }

    private short getNextEmpty(short in) {
        while (!this.requests.containsKey(in)) {
            in = (short)(in + 1);
        }
        return in;
    }

    public synchronized <T, K> void accordPackageReceive(RequestDataPacket<T, K> packet) {
        try {
            short key = packet.getId();
            Consumer<?> consumer = this.requests.get(key);
            consumer.accept(packet.getData());
            this.requests.remove(key);
            this.nextEmpty = key;
        }
        catch (Exception e) {
            KapLibMod.LOGGER.warn(Markers.REQUESTS, "error receiving packet: {}", (Object)e.getMessage());
        }
    }
}

