/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.loot_table.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.kapitencraft.kap_lib.io.serialization.JsonSerializer;
import net.kapitencraft.kap_lib.item.loot_table.LootContextReader;
import net.kapitencraft.kap_lib.item.loot_table.conditions.BaseCondition;
import net.kapitencraft.kap_lib.registry.ModLootItemConditions;
import net.kapitencraft.kap_lib.util.Reference;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagKeyCondition
extends BaseCondition {
    private static final TagKeyCondition EMPTY = new TagKeyCondition(null, "", null);
    public static final Codec<TagKeyCondition> CODEC = RecordCodecBuilder.create(tagKeyConditionInstance -> tagKeyConditionInstance.group((App)Type.CODEC.fieldOf("type").forGetter(TagKeyCondition::type), (App)Codec.STRING.fieldOf("id").forGetter(TagKeyCondition::getId), (App)Codec.STRING.optionalFieldOf("target").forGetter(TagKeyCondition::makeCodecTarget)).apply((Applicative)tagKeyConditionInstance, TagKeyCondition::fromCodec));
    private final String id;
    private final Type type;
    @Nullable
    private final LootContext.EntityTarget target;
    public static final JsonSerializer<TagKeyCondition> SERIALIZER = new JsonSerializer<TagKeyCondition>(CODEC, () -> EMPTY);

    private Optional<String> makeCodecTarget() {
        return this.target == null ? Optional.empty() : Optional.of(this.target.getName());
    }

    public static TagKeyCondition fromCodec(Type type, String tagId, Optional<String> entityTarget) {
        return new TagKeyCondition(type, tagId, TagKeyCondition.of(entityTarget));
    }

    @Nullable
    private static LootContext.EntityTarget of(Optional<String> optional) {
        return optional.map(LootContext.EntityTarget::m_79006_).orElse(null);
    }

    public TagKeyCondition(Type type, String tagId, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LootContext.EntityTarget target) {
        this.type = type;
        this.id = tagId;
        this.target = target;
    }

    public Type type() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootItemConditions.TAG_KEY.get();
    }

    public boolean test(LootContext context) {
        if (this == EMPTY) {
            return false;
        }
        Reference<Boolean> reference = Reference.of(false);
        switch (this.type) {
            case ENTITY: 
            case ITEM: {
                LootContextReader.simple(context, Entity.class, this.target.m_79003_()).ifPresent(entity -> {
                    if (this.type == Type.ENTITY) {
                        reference.setValue(entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(this.id))));
                    } else {
                        Boolean bl;
                        if (entity instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity;
                            bl = living.m_21205_().m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(this.id)));
                        } else {
                            bl = false;
                        }
                        reference.setValue(bl);
                    }
                });
                break;
            }
            case BLOCK: {
                LootContextReader.simple(context, BlockState.class, LootContextParams.f_81461_).ifPresent(state -> reference.setValue(state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(this.id)))));
            }
        }
        return reference.getValue();
    }

    public static enum Type implements StringRepresentable
    {
        ENTITY("entities"),
        BLOCK("blocks"),
        ITEM("items"),
        EMPTY("empty");

        public static final Codec<Type> CODEC;
        private final String name;

        public boolean is(LootContext context) {
            return context.getQueriedLootTableId().m_135815_().contains(this.name);
        }

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }
}

