/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements.type.abstracts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.kapitencraft.kap_lib.io.serialization.DataGenSerializer;
import net.kapitencraft.kap_lib.registry.custom.ModRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public abstract class ReqCondition<T extends ReqCondition<T>> {
    private Component displayCache;

    public static <T extends ReqCondition<T>> DataGenSerializer<T> createSerializer(Codec<T> codec, FriendlyByteBuf.Reader<T> factory) {
        return new DataGenSerializer<T>(codec, factory, (buf, t) -> t.toNetwork((FriendlyByteBuf)buf));
    }

    protected ReqCondition() {
    }

    public abstract boolean matches(Player var1);

    public abstract DataGenSerializer<T> getSerializer();

    @NotNull
    protected abstract Component cacheDisplay();

    @NotNull
    public Component display() {
        return this.displayCache == null ? (this.displayCache = this.cacheDisplay()) : this.displayCache;
    }

    public static <T extends ReqCondition<T>> ReqCondition<T> readFromJson(JsonObject object) {
        DataGenSerializer serializer = (DataGenSerializer)ModRegistries.REQUIREMENT_TYPE.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type")));
        if (serializer == null) {
            throw new NullPointerException("unknown requirement type: '" + GsonHelper.m_13906_((JsonObject)object, (String)"type") + "'");
        }
        return (ReqCondition)serializer.deserialize(object);
    }

    public JsonElement saveToJson() {
        JsonObject object = (JsonObject)this.getSerializer().serialize(this);
        object.addProperty("type", Objects.requireNonNull(ModRegistries.REQUIREMENT_TYPE.getKey(this.getSerializer()), "unknown requirement type: " + this.getClass().getCanonicalName()).toString());
        return object;
    }

    public void toNetwork(FriendlyByteBuf byteBuf) {
        byteBuf.writeRegistryId(ModRegistries.REQUIREMENT_TYPE, this.getSerializer());
        this.additionalToNetwork(byteBuf);
    }

    protected abstract void additionalToNetwork(FriendlyByteBuf var1);

    public static <T extends ReqCondition<T>> ReqCondition<T> fromNetwork(FriendlyByteBuf buf) {
        DataGenSerializer serializer = (DataGenSerializer)buf.readRegistryId();
        return (ReqCondition)serializer.fromNetwork(buf);
    }
}

