/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util.particle_help.animation.elements;

import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.particle_help.animation.ParticleAnimator;
import net.kapitencraft.kap_lib.util.particle_help.animation.elements.ParticleAnimationElement;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class OrbitAnimationElement
extends ParticleAnimationElement {
    private final int rotPerTick;
    private final int aliveTime;
    private int currentTick = 0;
    private int curRot = 0;
    private int cumTime = 0;
    private final ParticleOptions options;
    private final float heightChangePerTick;
    private final float maxHeight;
    private float curHeightChange = 0.0f;
    private boolean rising = true;

    public OrbitAnimationElement(String id, int amount, int rotPerTick, ParticleOptions options, int aliveTime, float heightChangePerTick, float maxHeight) {
        super(amount, id);
        this.rotPerTick = rotPerTick;
        this.options = options;
        this.aliveTime = aliveTime;
        this.heightChangePerTick = heightChangePerTick;
        this.maxHeight = maxHeight;
    }

    public OrbitAnimationElement(String id, int amount, int rotPerTick, ParticleOptions options, int aliveTime, float maxHeight) {
        this(id, amount, rotPerTick, options, aliveTime, (float)(0.5 * (360.0 / (double)rotPerTick) * (double)maxHeight), maxHeight);
    }

    @Override
    public boolean tick(ParticleAnimator animator) {
        if (this.currentTick++ >= 120) {
            this.currentTick = 0;
        }
        if (this.cumTime++ >= this.aliveTime) {
            return true;
        }
        Vec3 targetPos = animator.target instanceof Projectile ? MathHelper.calculateViewVector(this.curRot, 0.0f) : MathHelper.calculateViewVector(0.0f, this.curRot);
        targetPos = MathHelper.clampLength(targetPos, 0.75).m_82549_(animator.target.m_20182_()).m_82520_(0.0, (double)this.curHeightChange, 0.0);
        animator.target.m_9236_().m_7106_(this.options, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 0.0, 0.0, 0.0);
        this.curRot += this.rotPerTick;
        this.applyHeightChange();
        return false;
    }

    @Override
    public void writeToNW(FriendlyByteBuf buf) {
        buf.m_130070_(this.getId());
        buf.writeInt(this.getAmount());
        buf.writeInt(this.rotPerTick);
        this.options.m_7711_(buf);
        buf.writeInt(this.aliveTime);
        buf.writeFloat(this.heightChangePerTick);
        buf.writeFloat(this.maxHeight);
    }

    @Override
    public ParticleAnimationElement readFromNW(FriendlyByteBuf buf) {
        return new OrbitAnimationElement(buf.m_130277_(), buf.readInt(), buf.readInt(), null, buf.readInt(), buf.readFloat());
    }

    private void applyHeightChange() {
        if (this.rising) {
            float distanceToMax = this.maxHeight - this.curHeightChange;
            if (distanceToMax < this.heightChangePerTick) {
                this.curHeightChange = this.maxHeight - (this.heightChangePerTick - distanceToMax);
                this.rising = false;
            } else {
                this.curHeightChange += this.heightChangePerTick;
            }
        } else {
            float distanceTo0 = this.curHeightChange;
            if (distanceTo0 < this.heightChangePerTick) {
                this.curHeightChange = 0.0f + (this.heightChangePerTick - distanceTo0);
                this.rising = true;
            } else {
                this.curHeightChange -= this.heightChangePerTick;
            }
        }
    }
}

