/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.kapitencraft.kap_lib.client.gui.BlockEntityMenu;
import net.kapitencraft.kap_lib.client.gui.screen.HoverScreenUpdatable;
import net.kapitencraft.kap_lib.client.gui.screen.IModScreen;
import net.kapitencraft.kap_lib.client.gui.screen.tooltip.HoverTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityScreen<BE extends BlockEntity, M extends BlockEntityMenu<BE>>
extends AbstractContainerScreen<M>
implements IModScreen {
    private final List<HoverTooltip> hoverTooltips = new ArrayList<HoverTooltip>();

    public BlockEntityScreen(M menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    public void addHoverTooltip(HoverTooltip tooltip) {
        this.hoverTooltips.add(tooltip);
    }

    protected void addHoverTooltipAndImgButton(HoverTooltip tooltip, WidgetSprites location, Button.OnPress onPress) {
        this.hoverTooltips.add(tooltip);
        this.addRenderableWidget((GuiEventListener)tooltip.createButton(location, this.leftPos, this.topPos, onPress));
    }

    protected void init() {
        super.init();
        this.hoverTooltips.clear();
    }

    protected void containerTick() {
        this.tickRequirements();
    }

    public void tickRequirements() {
        if (this.hoverTooltips.stream().filter(tooltip -> tooltip instanceof HoverScreenUpdatable).map(tooltip -> (HoverScreenUpdatable)tooltip).filter(HoverScreenUpdatable::changed).peek(HoverScreenUpdatable::tick).findAny().isPresent()) {
            this.rebuildWidgets();
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.blit(this.getTexture(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public abstract ResourceLocation getTexture();

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (((BlockEntityMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot == null) {
            this.hoverTooltips.forEach(tooltip -> {
                if (tooltip.hovered(this.leftPos, this.topPos, mouseX, mouseY)) {
                    graphics.renderTooltip(Minecraft.getInstance().font, tooltip.getText(), Optional.empty(), mouseX, mouseY);
                }
            });
        }
    }
}

