/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.event;

import java.util.Collection;
import java.util.List;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.elements.MoveTowardsBBElement;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.RemoveParticleFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.EntityBBSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.EntityRemovedTerminatorTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.TimedTerminator;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBowEffect;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentCountEffect;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.InventoryHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.io.network.S2C.DisplayTotemActivationPacket;
import net.kapitencraft.kap_lib.item.bonus.BonusManager;
import net.kapitencraft.kap_lib.item.combat.totem.AbstractTotemItem;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ExtraEnchantmentEffectComponents;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.util.DamageCounter;
import net.kapitencraft.kap_lib.util.FerociousDamageSource;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber
@ApiStatus.Internal
public class DamageEvents {
    private DamageEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void miscDamageEvents(LivingDamageEvent.Pre event) {
        LivingEntity attacked = event.getEntity();
        LivingEntity attacker = MiscHelper.getAttacker(event.getSource());
        event.setNewDamage(BonusManager.attackEvent(attacked, attacker, MiscHelper.getDamageType(event.getSource()), event.getNewDamage()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utilDamage(LivingDamageEvent.Pre event) {
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        boolean dodge = false;
        double dodgePercentage = AttributeHelper.getSaveAttributeValue(ExtraAttributes.DODGE, attacked);
        if (dodgePercentage > 0.0 && MathHelper.chance(dodgePercentage / 100.0, attacked) && (!source.is(DamageTypeTags.BYPASSES_ARMOR) && !source.is(DamageTypeTags.IS_FALL) && !source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypes.STALAGMITE))) {
            dodge = true;
            event.setNewDamage(0.0f);
        }
        MiscHelper.createDamageIndicator(attacked, event.getNewDamage(), dodge ? "dodge" : source.getMsgId());
        DamageCounter.increaseDamage(event.getNewDamage());
    }

    @SubscribeEvent
    public static void critDamageRegister(CriticalHitEvent event) {
        Player attacker = event.getEntity();
        if (event.isVanillaCritical() || AttributeHelper.getSaveAttributeValue(ExtraAttributes.CRIT_CHANCE, (LivingEntity)attacker) / 100.0 > Math.random()) {
            event.setCriticalHit(true);
            event.setDamageMultiplier((float)(1.0 + AttributeHelper.getSaveAttributeValue(ExtraAttributes.CRIT_DAMAGE, (LivingEntity)attacker) / 100.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void ferocityRegister(LivingDamageEvent.Pre event) {
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        LivingEntity attacker = MiscHelper.getAttacker(source);
        if (attacker == null || MiscHelper.getDamageType(source) != MiscHelper.DamageType.MELEE) {
            return;
        }
        if (attacker.getAttribute(ExtraAttributes.FEROCITY) != null) {
            double ferocity;
            if (source instanceof FerociousDamageSource) {
                FerociousDamageSource damageSource = (FerociousDamageSource)source;
                v0 = damageSource.ferocity;
            } else {
                v0 = ferocity = attacker.getAttributeValue(ExtraAttributes.FEROCITY);
            }
            if (MathHelper.chance(ferocity / 100.0, attacker)) {
                MiscHelper.schedule(40, () -> {
                    double d;
                    if (source instanceof FerociousDamageSource) {
                        FerociousDamageSource ferociousDamageSource = (FerociousDamageSource)source;
                        d = ferociousDamageSource.damage;
                    } else {
                        Entity entity = source.getEntity();
                        if (entity instanceof AbstractArrow) {
                            AbstractArrow arrow = (AbstractArrow)entity;
                            d = arrow.getBaseDamage();
                        } else {
                            d = attacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
                        }
                    }
                    float ferocityDamage = (float)d;
                    if (attacked.isDeadOrDying()) {
                        return;
                    }
                    attacked.level().playSound((Entity)attacked, attacked.getOnPos(), SoundEvents.IRON_GOLEM_ATTACK, SoundSource.HOSTILE, 1.0f, 0.5f);
                    attacked.hurt((DamageSource)FerociousDamageSource.create((Entity)attacker, ferocity - 100.0, ferocityDamage), ferocityDamage);
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void damageBonusRegister(LivingDamageEvent.Pre event) {
        Level tag;
        LivingEntity attacked = event.getEntity();
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            tag = arrow.getPersistentData();
            event.setNewDamage(EnchantmentBowEffect.loadFromTag(attacked, (CompoundTag)tag, EnchantmentBowEffect.ExePhase.HIT, event.getNewDamage(), (AbstractArrow)arrow));
        }
        if ((tag = attacked.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)tag;
            DamageSource source = event.getSource();
            LivingEntity attacker = MiscHelper.getAttacker(source);
            if (attacker == null) {
                return;
            }
            ItemStack stack = attacker.getMainHandItem();
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (EquipmentSlot)EquipmentSlot.MAINHAND, (LivingEntity)attacker, (enchantment, level, item) -> {
                LootContext context = Enchantment.damageContext((ServerLevel)serverLevel, (int)level, (Entity)attacked, (DamageSource)source);
                List effect = ((Enchantment)enchantment.value()).getEffects((DataComponentType)ExtraEnchantmentEffectComponents.COUNT.get());
                MutableFloat damage = new MutableFloat(event.getNewDamage());
                for (TargetedConditionalEffect conditionalEffect : effect) {
                    if (!conditionalEffect.matches(context)) continue;
                    damage.setValue(((EnchantmentCountEffect)conditionalEffect.effect()).tryExecute((Holder<Enchantment>)enchantment, level, item, attacker, attacked, damage.floatValue(), source));
                }
                event.setNewDamage(damage.floatValue());
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void damageAttributeRegister(LivingDamageEvent.Pre event) {
        Level level;
        LivingEntity attacker = MiscHelper.getAttacker(event.getSource());
        if (attacker == null) {
            return;
        }
        if (MiscHelper.getDamageType(event.getSource()) == MiscHelper.DamageType.MELEE && attacker.getAttributes().hasAttribute(ExtraAttributes.STRENGTH)) {
            double Strength = AttributeHelper.getSaveAttributeValue(ExtraAttributes.STRENGTH, attacker);
            MathHelper.mul(() -> ((LivingDamageEvent.Pre)event).getNewDamage(), arg_0 -> ((LivingDamageEvent.Pre)event).setNewDamage(arg_0), (float)(1.0 + Strength / 100.0));
        }
        double armorShredder = AttributeHelper.getSaveAttributeValue(ExtraAttributes.ARMOR_SHREDDER, attacker);
        LivingEntity attacked = event.getEntity();
        if (armorShredder > 0.0 && (level = attacked.level()) instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            MiscHelper.getArmorEquipment(attacked).forEach(stack -> {
                ServerPlayer serverPlayer;
                stack.hurtAndBreak((int)(armorShredder / 3.0), sL, attacker instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)attacker) : null, i -> {});
            });
        }
        double liveSteal = AttributeHelper.getSaveAttributeValue(ExtraAttributes.LIFE_STEAL, attacker);
        if (event.getSource().isDirect() && liveSteal > 0.0) {
            Level level2 = attacker.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel sL = (ServerLevel)level2;
                ParticleAnimation.builder().spawn(((EntityBBSpawner.Builder)EntityBBSpawner.builder().setParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)0x800000).toVector3f(), 0.3f))).target((Entity)attacked).perTick(150).scaleX(1.3f).scaleY(1.1f)).then(MoveTowardsBBElement.builder().target((Entity)attacker).duration(30)).finalizes(RemoveParticleFinalizer.builder()).spawnTime(ParticleAnimation.SpawnTime.once()).terminatedWhen(TimedTerminator.ticks(20)).terminatedWhen(EntityRemovedTerminatorTrigger.create((Entity)attacked)).terminatedWhen(EntityRemovedTerminatorTrigger.create((Entity)attacker)).sendToAllPlayers();
            }
            attacker.heal(Math.min((float)liveSteal, event.getNewDamage()));
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        event.setCanceled(!RequirementManager.meetsItemRequirementsFromEvent((LivingEvent)event, EquipmentSlot.MAINHAND));
    }

    @SubscribeEvent
    public static void shieldBlockEnchantments(LivingShieldBlockEvent event) {
        LivingEntity attacked = event.getEntity();
        LivingEntity attacker = MiscHelper.getAttacker(event.getDamageSource());
        if (attacker == null) {
            return;
        }
        ItemStack stack = attacker.getUseItem();
        MiscHelper.DamageType type = MiscHelper.getDamageType(event.getDamageSource());
        EnchantedItemInUse shield = new EnchantedItemInUse(stack, attacked.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, attacked);
        Level level2 = attacker.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantment, level) -> {
                List effects = ((Enchantment)enchantment.value()).getEffects((DataComponentType)ExtraEnchantmentEffectComponents.SHIELD_BLOCK.get());
                LootContext lootContext = Enchantment.damageContext((ServerLevel)serverLevel, (int)level, (Entity)event.getEntity(), (DamageSource)event.getDamageSource());
                effects.forEach(effect -> {
                    if (effect.matches(lootContext)) {
                        LivingEntity entity = switch (effect.affected()) {
                            default -> throw new MatchException(null, null);
                            case EnchantmentTarget.ATTACKER -> attacker;
                            case EnchantmentTarget.DAMAGING_ENTITY -> event.getDamageSource().getDirectEntity();
                            case EnchantmentTarget.VICTIM -> attacked;
                        };
                        ((EnchantmentEntityEffect)effect.effect()).apply(serverLevel, level, shield, (Entity)entity, attacked.position());
                    }
                });
            });
        }
    }

    @SubscribeEvent
    public static void entityDeathEvents(LivingDeathEvent event) {
        LivingEntity toDie = event.getEntity();
        if (toDie instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)toDie;
            Collection<ItemStack> totems = InventoryHelper.getByFilter((Player)player, stack -> stack.getItem() instanceof AbstractTotemItem);
            if (!event.isCanceled()) {
                for (ItemStack stack2 : totems) {
                    AbstractTotemItem totemItem = (AbstractTotemItem)stack2.getItem();
                    if (!totemItem.onUse((LivingEntity)player, event.getSource())) continue;
                    player.awardStat(Stats.ITEM_USED.get((Object)totemItem));
                    event.setCanceled(true);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DisplayTotemActivationPacket(stack2.copy(), player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    stack2.shrink(1);
                    break;
                }
            }
        }
        if (!event.isCanceled()) {
            BonusManager.deathEvent(toDie, event.getSource());
        }
    }
}

