/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public class ManaConsumedTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(i -> i.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)Type.CODEC.fieldOf("type").forGetter(inst -> inst.type), (App)Codec.DOUBLE.fieldOf("value").forGetter(inst -> inst.value)).apply((Applicative)i, Instance::new));

    public Codec<Instance> codec() {
        return CODEC;
    }

    public void trigger(ServerPlayer pPlayer, double amount) {
        this.trigger(pPlayer, instance -> instance.enough(amount));
    }

    public Criterion<Instance> exactly(double value) {
        return new Criterion((CriterionTrigger)this, (CriterionTriggerInstance)new Instance(Optional.empty(), Type.EXACTLY, value));
    }

    public Criterion<Instance> above(double value) {
        return new Criterion((CriterionTrigger)this, (CriterionTriggerInstance)new Instance(Optional.empty(), Type.MORE, value));
    }

    public Criterion<Instance> below(double value) {
        return new Criterion((CriterionTrigger)this, (CriterionTriggerInstance)new Instance(Optional.empty(), Type.LESS, value));
    }

    public static class Instance
    implements SimpleCriterionTrigger.SimpleInstance {
        private final ContextAwarePredicate player;
        private final Type type;
        private final double value;

        private Instance(Optional<ContextAwarePredicate> player, Type type, double value) {
            this.player = player.orElse(null);
            this.type = type;
            this.value = value;
        }

        public Optional<ContextAwarePredicate> player() {
            return Optional.ofNullable(this.player);
        }

        public boolean enough(double mana) {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> {
                    if (mana <= this.value) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> {
                    if (mana == this.value) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> mana >= this.value;
            };
        }
    }

    private static enum Type implements StringRepresentable
    {
        EXACTLY,
        LESS,
        MORE;

        private static final StringRepresentable.EnumCodec<Type> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

