/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.gui.screen.MenuableScreen;
import net.kapitencraft.kap_lib.client.overlay.OverlayManager;
import net.kapitencraft.kap_lib.client.overlay.box.ResizeBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.MultiElementSelectorElement;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigureOverlaysScreen
extends MenuableScreen {
    private final OverlayManager controller = LibClient.overlays;
    private final List<ResizeBox> boxes = new ArrayList<ResizeBox>();
    private ResizeBox active;
    private final Map<Overlay, ResizeBox> boxesForOverlay = new HashMap<Overlay, ResizeBox>();

    ConfigureOverlaysScreen() {
        super((Component)Component.translatable((String)"configure_overlays.title"));
        this.setDefaultMenuBuilder((x, y, screen) -> {
            DropDownMenu menu = new DropDownMenu(x, y, (GuiEventListener)this);
            menu.addElement(((MultiElementSelectorElement.Builder)MultiElementSelectorElement.builder(Overlay.class).setName((Component)Component.translatable((String)"gui.overlays"))).setElements(this.controller.map.values()).setStatusMapper(Overlay::isVisible).setNameMapper(Overlay::getName).setOnChange((overlay, aBoolean) -> {
                OverlayManager.setVisible(overlay, aBoolean);
                if (aBoolean.booleanValue()) {
                    ResizeBox box = overlay.newBox(this.width, this.height, Minecraft.getInstance().player, this.font);
                    this.boxes.add(box);
                    this.boxesForOverlay.put((Overlay)overlay, box);
                    overlay.setVisible(true);
                } else {
                    this.removeOverlay((Overlay)overlay);
                }
            }));
            return menu;
        });
    }

    public void removeOverlay(Overlay overlay) {
        this.boxes.remove(this.boxesForOverlay.get(overlay));
        overlay.setVisible(false);
    }

    protected void init() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        this.boxes.clear();
        this.controller.fillRenderBoxes(this.boxes::add, this.boxesForOverlay::put, player, this.font, this.width, this.height);
        super.init();
    }

    @NotNull
    public List<ResizeBox> children() {
        return this.boxes;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.active != null && this.active.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double x, double y, int pButton) {
        if (this.active == null) {
            return false;
        }
        this.active.mouseRelease(x, y);
        this.active = null;
        ClientHelper.changeCursorType(221185);
        return true;
    }

    private List<ResizeBox> getHovering(double x, double y) {
        return this.boxes.stream().filter(interactiveBox -> interactiveBox.isMouseOver(x, y)).toList();
    }

    @Override
    public void mouseMoved(double x, double y) {
        super.mouseMoved(x, y);
        this.getHovering(x, y).forEach(interactiveBox -> interactiveBox.mouseMove(x, y));
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            GuiEventListener guiEventListener = this.getFocused();
            if (guiEventListener instanceof ResizeBox) {
                ResizeBox rBox;
                this.active = rBox = (ResizeBox)guiEventListener;
                int arrowId = rBox.getActiveArrowId();
                ClientHelper.changeCursorType(arrowId);
            }
            return true;
        }
        return false;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        this.boxes.forEach(interactiveBox -> interactiveBox.render(graphics, mouseX, mouseY));
        super.render(graphics, mouseX, mouseY, pPartialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 5, -11579569);
        if (this.active == null) {
            int arrowId = this.boxes.stream().map(box -> box.getCursorType(mouseX, mouseY)).filter(i -> i != 221185).findFirst().orElse(221185);
            ClientHelper.changeCursorType(arrowId);
        }
    }

    public void onClose() {
        OverlayManager.save();
        super.onClose();
    }
}

