/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.cam.core;

import net.kapitencraft.kap_lib.client.cam.core.CameraData;
import net.kapitencraft.kap_lib.client.cam.core.TrackingShot;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class CameraController {
    private final Camera camera;
    private boolean running;
    private boolean wasHiding;
    private TrackingShot shot;
    public final CameraData data;
    private boolean shaking;
    private float oShake;
    private float shake;
    private float shakeVal;
    private float shakeIntensity;
    private float shakeFrequency;
    private int shakeTime;

    public CameraController() {
        this.camera = Minecraft.m_91087_().f_91063_.m_109153_();
        this.running = false;
        this.wasHiding = false;
        this.shaking = false;
        this.shakeTime = 0;
        this.data = new CameraData();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void activate(TrackingShot shot) {
        this.running = true;
        this.shot = shot;
        shot.setup();
        Vec3 pos = this.camera.m_90583_();
        Vec2 rot = new Vec2(this.camera.m_90589_(), this.camera.m_90590_());
        this.data.update(pos, rot);
        Options options = Minecraft.m_91087_().f_91066_;
        this.wasHiding = options.f_92062_;
        options.f_92062_ = true;
    }

    public void shake(float intensity, float strength, float frequency) {
        this.shaking = true;
        this.shakeIntensity = intensity;
        this.shakeVal = strength;
        this.shakeFrequency = frequency;
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.running) {
            if (this.shot.done()) {
                this.disable();
            } else {
                this.data.tick();
                this.shot.tick(this.data);
            }
        }
        if (this.shaking) {
            this.oShake = this.shake;
            this.shake = Mth.m_14031_((float)((float)this.shakeTime++ * this.shakeFrequency)) * this.shakeVal;
            this.shakeVal -= this.shakeIntensity;
            if (this.shakeVal <= 0.0f) {
                this.shaking = false;
            }
        }
    }

    private void disable() {
        this.running = false;
        Minecraft.m_91087_().f_91066_.f_92062_ = this.wasHiding;
    }

    @SubscribeEvent
    public void onViewportComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        double partialTick = event.getPartialTick();
        if (this.running) {
            Vec3 rot = this.data.getRot(partialTick);
            event.setPitch((float)rot.f_82479_);
            event.setYaw((float)rot.f_82480_);
            event.setRoll((float)rot.f_82481_);
            event.getCamera().m_90581_(this.data.getPos(partialTick));
        }
        if (!(!this.shaking || this.running && this.shot.suppressesShake())) {
            Vec3 pos = event.getCamera().m_90583_();
            event.getCamera().m_90581_(pos.m_82520_(0.0, (double)Mth.m_14179_((float)((float)partialTick), (float)this.oShake, (float)this.shake), 0.0));
        }
    }

    public boolean running() {
        return this.running;
    }
}

