/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.cam.core;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.cam.core.TrackingShot;
import net.kapitencraft.kap_lib.client.cam.modifiers.GroupModifier;
import net.kapitencraft.kap_lib.client.cam.modifiers.Modifier;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class TrackingShotData {
    final boolean suppressShake;
    final Modifier[] modifiers;
    final int[] times;

    public TrackingShotData(boolean suppressShake, Modifier[] modifiers, int[] modifierTimes) {
        this.suppressShake = suppressShake;
        this.modifiers = modifiers;
        this.times = modifierTimes;
    }

    public boolean suppressesShake() {
        return this.suppressShake;
    }

    public void toNw(FriendlyByteBuf buf) {
        buf.writeBoolean(this.suppressShake);
        NetworkHelper.writeArray(buf, this.modifiers, Modifier::toNw);
        buf.m_130089_(this.times);
    }

    public static TrackingShotData fromNw(FriendlyByteBuf buf) {
        return new TrackingShotData(buf.readBoolean(), (Modifier[])NetworkHelper.readArray(buf, Modifier[]::new, Modifier::fromNw), buf.m_130100_());
    }

    public static class Builder {
        private final List<Modifier> modifiers = new ArrayList<Modifier>();
        private final List<Integer> modifierTimes = new ArrayList<Integer>();
        private boolean suppressShake = false;

        public Builder addModifier(@NotNull Modifier modifier, int duration) {
            Preconditions.checkNotNull((Object)modifier, (Object)"detected null modifier!");
            this.modifiers.add(modifier);
            this.modifierTimes.add(duration);
            return this;
        }

        public Builder addRotAndPosModifier(@NotNull Modifier posModifier, @NotNull Modifier rotModifier, int duration) {
            return this.addGroupModifier(duration, rotModifier, posModifier);
        }

        public Builder addGroupModifier(int duration, Modifier ... modifiers) {
            return this.addModifier(new GroupModifier(modifiers), duration);
        }

        public Builder suppressesShake() {
            this.suppressShake = true;
            return this;
        }

        public TrackingShotData toData() {
            return new TrackingShotData(this.suppressShake, this.modifiers.toArray(new Modifier[0]), this.modifierTimes.stream().mapToInt(Integer::intValue).toArray());
        }

        public TrackingShot build() {
            return new TrackingShot(this.toData());
        }
    }
}

