/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.kapitencraft.kap_lib.client.gui.BlockEntityMenu;
import net.kapitencraft.kap_lib.client.gui.screen.HoverScreenUpdatable;
import net.kapitencraft.kap_lib.client.gui.screen.IModScreen;
import net.kapitencraft.kap_lib.client.gui.screen.tooltip.HoverTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityScreen<BE extends BlockEntity, M extends BlockEntityMenu<BE>>
extends AbstractContainerScreen<M>
implements IModScreen {
    private final List<HoverTooltip> hoverTooltips = new ArrayList<HoverTooltip>();

    public BlockEntityScreen(M menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    public void addHoverTooltip(HoverTooltip tooltip) {
        this.hoverTooltips.add(tooltip);
    }

    protected void addHoverTooltipAndImgButton(HoverTooltip tooltip, ResourceLocation location, Button.OnPress onPress) {
        this.hoverTooltips.add(tooltip);
        this.m_142416_((GuiEventListener)tooltip.createButton(location, this.f_97735_, this.f_97736_, onPress));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.hoverTooltips.clear();
    }

    protected void m_181908_() {
        this.tickRequirements();
    }

    public void tickRequirements() {
        if (this.hoverTooltips.stream().filter(tooltip -> tooltip instanceof HoverScreenUpdatable).map(tooltip -> (HoverScreenUpdatable)tooltip).filter(HoverScreenUpdatable::changed).peek(HoverScreenUpdatable::tick).findAny().isPresent()) {
            this.m_232761_();
        }
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280163_(this.getTexture(), this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        RenderSystem.disableBlend();
    }

    public abstract ResourceLocation getTexture();

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
        if (((BlockEntityMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ == null) {
            this.hoverTooltips.forEach(tooltip -> {
                if (tooltip.hovered(this.f_97735_, this.f_97736_, mouseX, mouseY)) {
                    graphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip.getText(), Optional.empty(), mouseX, mouseY);
                }
            });
        }
    }
}

