/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class OverlayProperties {
    public static final Codec<OverlayProperties> CODEC = RecordCodecBuilder.create(positionHolderInstance -> positionHolderInstance.group((App)Axis.CODEC.fieldOf("x").forGetter(h -> h.x), (App)Axis.CODEC.fieldOf("y").forGetter(h -> h.y), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(OverlayProperties::isVisible)).apply((Applicative)positionHolderInstance, OverlayProperties::new));
    private final Axis x;
    private final Axis y;
    private boolean visible;

    private OverlayProperties(Axis x, Axis y, boolean visible) {
        this.x = x;
        this.y = y;
        this.visible = visible;
    }

    public OverlayProperties(float x, float y, float sX, float sY, Alignment aX, Alignment aY) {
        this(new Axis(x, sX, aX), new Axis(y, sY, aY), true);
    }

    public OverlayProperties copy(OverlayProperties other) {
        this.x.copy(other.x);
        this.y.copy(other.y);
        return this;
    }

    public OverlayProperties setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public Alignment getXAlignment() {
        return this.x.getAlignment();
    }

    public Alignment getYAlignment() {
        return this.y.getAlignment();
    }

    public void add(Vec2 loc) {
        this.x.add(loc.f_82470_);
        this.y.add(loc.f_82471_);
    }

    public void addX(float offset) {
        this.x.add(offset);
    }

    public void addY(float offset) {
        this.y.add(offset);
    }

    public void scale(float x, float y) {
        this.x.scale *= x;
        this.y.scale *= y;
    }

    public void scaleX(float scaleX) {
        this.x.scale *= scaleX;
    }

    public void scaleY(float scaleY) {
        this.y.scale *= scaleY;
    }

    public float getXScale() {
        return this.x.getScale();
    }

    public float getYScale() {
        return this.y.getScale();
    }

    public Vec2 getLoc(float width, float height) {
        return new Vec2(this.x.getVisualLoc(width), this.y.getVisualLoc(height));
    }

    public OverlayProperties createCopy() {
        return new OverlayProperties(this.x.copy(), this.y.copy(), this.visible);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setXAlignment(Alignment alignment) {
        this.x.changeAlignment(alignment, ClientHelper.getScreenWidth());
    }

    public void setYAlignment(Alignment alignment) {
        this.y.changeAlignment(alignment, ClientHelper.getScreenHeight());
    }

    private static class Axis {
        private static final Codec<Axis> CODEC = RecordCodecBuilder.create(axisInstance -> axisInstance.group((App)Codec.FLOAT.fieldOf("value").forGetter(Axis::value), (App)Codec.FLOAT.fieldOf("scale").forGetter(Axis::getScale), (App)Alignment.CODEC.fieldOf("alignment").forGetter(Axis::getAlignment)).apply((Applicative)axisInstance, Axis::new));
        public float value;
        public float scale;
        public Alignment alignment;

        private Axis(float value, float scale, Alignment alignment) {
            this.value = value;
            this.scale = scale;
            this.alignment = alignment;
        }

        private float value() {
            return this.value;
        }

        public float getScale() {
            return this.scale;
        }

        public Alignment getAlignment() {
            return this.alignment;
        }

        public float getVisualLoc(float axisMax) {
            return switch (this.alignment) {
                default -> throw new IncompatibleClassChangeError();
                case Alignment.TOP_LEFT -> this.value;
                case Alignment.MIDDLE -> axisMax / 2.0f + this.value;
                case Alignment.BOTTOM_RIGHT -> axisMax - this.value;
            };
        }

        public Axis copy() {
            return new Axis(this.value, this.scale, this.alignment);
        }

        private void copy(Axis axis) {
            this.value = axis.value;
            this.scale = axis.scale;
            this.alignment = axis.alignment;
        }

        public void add(float var) {
            this.value = this.alignment == Alignment.BOTTOM_RIGHT ? (this.value -= var) : (this.value += var);
        }

        public void changeAlignment(Alignment change, float axisLength) {
            this.value = change.convert(this.alignment, this.value, axisLength);
            this.alignment = change;
        }
    }

    public static enum Alignment implements StringRepresentable
    {
        TOP_LEFT("top"),
        BOTTOM_RIGHT("bottom"),
        MIDDLE("middle");

        private static final StringRepresentable.EnumCodec<Alignment> CODEC;
        private final String name;

        private Alignment(String name) {
            this.name = name;
        }

        public Component getName(boolean x) {
            return Component.m_237115_((String)("alignment." + (x ? "x" : "y") + "." + this.name));
        }

        public Component getWidthName() {
            return this.getName(true);
        }

        public Component getHeightName() {
            return this.getName(false);
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public float convert(Alignment other, float value, float axisMax) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case TOP_LEFT -> {
                    switch (other) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case BOTTOM_RIGHT: {
                            yield axisMax - value;
                        }
                        case MIDDLE: {
                            yield axisMax / 2.0f + value;
                        }
                        case TOP_LEFT: 
                    }
                    yield value;
                }
                case MIDDLE -> {
                    switch (other) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case BOTTOM_RIGHT: {
                            yield axisMax / 2.0f - value;
                        }
                        case MIDDLE: {
                            yield value;
                        }
                        case TOP_LEFT: 
                    }
                    yield value - axisMax / 2.0f;
                }
                case BOTTOM_RIGHT -> {
                    switch (other) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case BOTTOM_RIGHT: {
                            yield value;
                        }
                        case MIDDLE: {
                            yield axisMax / 2.0f - value;
                        }
                        case TOP_LEFT: 
                    }
                    yield axisMax - value;
                }
            };
        }

        static {
            CODEC = StringRepresentable.m_216439_(Alignment::values);
        }
    }
}

