/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay.holder;

import net.kapitencraft.kap_lib.client.overlay.OverlayManager;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.box.ResizeBox;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public abstract class Overlay {
    private final OverlayProperties properties;
    private final Component name;

    public Overlay(OverlayProperties holder, Component name) {
        this.properties = holder;
        this.name = name;
    }

    public Vec2 getLoc(float screenWidth, float screenHeight) {
        return this.properties.getLoc(screenWidth, screenHeight);
    }

    public void move(Vec2 toAdd) {
        this.properties.add(toAdd);
    }

    public void moveX(float offset) {
        this.properties.addX(offset);
    }

    public void moveY(float offset) {
        this.properties.addY(offset);
    }

    public ResizeBox newBox(float screenWidth, float screenHeight, LocalPlayer player, Font font) {
        Vec2 loc = this.getLoc(screenWidth, screenHeight);
        float width = this.getWidth(player, font) * this.properties.getXScale();
        float height = this.getHeight(player, font) * this.properties.getYScale();
        return new ResizeBox(loc.m_165910_(new Vec2(-1.0f, -2.0f)), loc.m_165910_(new Vec2(width + 1.0f, height)), this);
    }

    public void reset(float screenWidth, float screenHeight, LocalPlayer player, Font font, ResizeBox resizeBox) {
        Vec2 loc = this.getLoc(screenWidth, screenHeight);
        float width = this.getWidth(player, font) * this.properties.getXScale();
        float height = this.getHeight(player, font) * this.properties.getYScale();
        resizeBox.start = loc.m_165910_(new Vec2(-1.0f, -2.0f));
        resizeBox.end = loc.m_165910_(new Vec2(width + 1.0f, height));
    }

    public abstract float getWidth(LocalPlayer var1, Font var2);

    public abstract float getHeight(LocalPlayer var1, Font var2);

    public abstract void render(ForgeGui var1, GuiGraphics var2, int var3, int var4, LocalPlayer var5);

    public OverlayProperties getProperties() {
        return this.properties;
    }

    public boolean isVisible() {
        return this.properties.isVisible();
    }

    public void setVisible(boolean b) {
        OverlayManager.setVisible(this, b);
        this.properties.setVisible(b);
    }

    public Component getName() {
        return this.name;
    }
}

