/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.registry.ExtraParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class LightningParticleOptions
extends ParticleType<LightningParticleOptions>
implements ParticleOptions {
    private static final Codec<LightningParticleOptions> CODEC = RecordCodecBuilder.create(lightningParticleOptionsInstance -> lightningParticleOptionsInstance.group((App)Vec3.f_231074_.fieldOf("start").forGetter(LightningParticleOptions::getStart), (App)Vec3.f_231074_.fieldOf("end").forGetter(LightningParticleOptions::getEnd), (App)Codec.INT.fieldOf("segments").forGetter(LightningParticleOptions::getSegments), (App)Codec.INT.fieldOf("lifetime").forGetter(LightningParticleOptions::getLifetime), (App)Codec.FLOAT.fieldOf("displacement").forGetter(LightningParticleOptions::getDisplacement), (App)Codec.FLOAT.fieldOf("width").forGetter(LightningParticleOptions::getWidth)).apply((Applicative)lightningParticleOptionsInstance, LightningParticleOptions::new));
    private final Vec3 start;
    private final Vec3 end;
    private final int segments;
    private final int lifetime;
    private final float displacement;
    private final float width;

    public LightningParticleOptions(Vec3 start, Vec3 end, @Range(from=2L, to=255L) int segments, int lifetime, float displacement, float width) {
        super(true, (ParticleOptions.Deserializer)new Deserializer());
        this.start = start;
        this.end = end;
        this.segments = segments;
        this.lifetime = lifetime;
        this.displacement = displacement;
        this.width = width;
    }

    public Vec3 getStart() {
        return this.start;
    }

    public Vec3 getEnd() {
        return this.end;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ExtraParticleTypes.LIGHTNING.get();
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        NetworkHelper.writeVec3(pBuffer, this.start);
        NetworkHelper.writeVec3(pBuffer, this.end);
        pBuffer.writeByte(this.segments);
        pBuffer.writeFloat(this.displacement);
        pBuffer.writeFloat(this.width);
    }

    @NotNull
    public String m_5942_() {
        return this.start.toString() + "-" + this.end.toString();
    }

    @NotNull
    public Codec<LightningParticleOptions> m_7652_() {
        return CODEC;
    }

    public int getSegments() {
        return this.segments;
    }

    public float getDisplacement() {
        return this.displacement;
    }

    public float getWidth() {
        return this.width;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    private static class Deserializer
    implements ParticleOptions.Deserializer<LightningParticleOptions> {
        private Deserializer() {
        }

        @NotNull
        public LightningParticleOptions fromCommand(ParticleType<LightningParticleOptions> pParticleType, StringReader pReader) throws CommandSyntaxException {
            Vec3 start = TextHelper.readVec3(pReader);
            pReader.expect('-');
            Vec3 end = TextHelper.readVec3(pReader);
            pReader.expect(' ');
            int segments = pReader.readInt();
            pReader.expect(' ');
            int lifetime = pReader.readInt();
            pReader.expect(' ');
            float displacement = pReader.readFloat();
            pReader.expect(' ');
            float width = pReader.readFloat();
            return new LightningParticleOptions(start, end, segments, lifetime, displacement, width);
        }

        public LightningParticleOptions fromNetwork(ParticleType<LightningParticleOptions> pParticleType, FriendlyByteBuf pBuffer) {
            Vec3 start = NetworkHelper.readVec3(pBuffer);
            Vec3 end = NetworkHelper.readVec3(pBuffer);
            int segments = pBuffer.readByte() & 0xFF;
            return new LightningParticleOptions(start, end, segments, pBuffer.readInt(), pBuffer.readFloat(), pBuffer.readFloat());
        }
    }
}

