/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class ParticleConfig {
    public double x;
    public double y;
    public double z;
    public double dx;
    public double dy;
    public double dz;
    public float r;
    public float g;
    public float b;
    public float a;
    public int lifeTime;
    public int age;
    private final Particle target;
    private int[] elementLengths;
    private int totalLength;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<BiConsumer<ParticleConfig, Integer>> tickers = new ArrayList<BiConsumer<ParticleConfig, Integer>>();
    private int tickCount;
    private int elementIndex;
    private int elementStartTick = 0;
    private final ParticleAnimation animation;
    private AnimationElement active;

    @ApiStatus.Internal
    public ParticleConfig(Particle target, ParticleAnimation animation) {
        this.target = target;
        this.animation = animation;
        this.init();
    }

    @ApiStatus.Internal
    public void sync() {
        this.target.f_107212_ = this.x;
        this.target.f_107213_ = this.y;
        this.target.f_107214_ = this.z;
        this.target.f_107227_ = this.r;
        this.target.f_107228_ = this.g;
        this.target.f_107229_ = this.b;
        this.target.f_107230_ = this.a;
        this.target.m_107257_(this.lifeTime);
        this.target.f_107215_ = this.dx;
        this.target.f_107216_ = this.dy;
        this.target.f_107217_ = this.dz;
        this.target.f_107224_ = this.age;
    }

    @ApiStatus.Internal
    private void init() {
        AnimationElement[] elements = this.animation.allElements();
        int[] counts = new int[elements.length];
        int totalLength = 0;
        for (int i = 0; i < elements.length; ++i) {
            counts[i] = elements[i].createLength(this);
            totalLength += counts[i];
        }
        this.elementLengths = counts;
        this.totalLength = totalLength;
        this.r = this.target.f_107227_;
        this.g = this.target.f_107228_;
        this.b = this.target.f_107229_;
        this.a = this.target.f_107230_;
        this.x = this.target.f_107212_;
        this.y = this.target.f_107213_;
        this.z = this.target.f_107214_;
        this.lifeTime = this.target.m_107273_();
        if (elements.length > 0) {
            this.active = elements[0];
            this.active.initialize(this);
        }
    }

    @ApiStatus.Internal
    public void tick() {
        if (this.tickCount - this.elementStartTick >= this.elementLengths[this.elementIndex]) {
            ++this.elementIndex;
            this.active.finalize(this);
            this.active = this.animation.getElement(this.elementIndex);
            this.properties.clear();
            this.active.initialize(this);
            this.elementStartTick = this.tickCount;
        }
        int currentTickCount = this.tickCount - this.elementStartTick;
        this.active.tick(this, currentTickCount, (double)currentTickCount / (double)(this.elementLengths[this.elementIndex] - 1));
        this.tickers.forEach(c -> c.accept(this, this.tickCount));
        ++this.tickCount;
        this.sync();
    }

    public void registerTicker(BiConsumer<ParticleConfig, Integer> ticker) {
        this.tickers.add(ticker);
    }

    public int completePercentage(AnimationElement element) {
        int elementIndex = CollectionHelper.index(this.animation.allElements(), element);
        if (elementIndex == -1) {
            throw new IllegalArgumentException("element " + element + " not found inside animation " + this.animation);
        }
        if (this.elementIndex < elementIndex) {
            return -1;
        }
        if (this.elementIndex > elementIndex) {
            return 2;
        }
        return this.activeCompletePercentage();
    }

    public int activeCompletePercentage() {
        return (this.tickCount - this.elementStartTick) / this.elementLengths[this.elementIndex];
    }

    public int remainingTicks() {
        return this.totalLength - this.tickCount;
    }

    public boolean hasExpired() {
        return this.remainingTicks() <= 0;
    }

    public void removeTarget() {
        this.target.m_107274_();
    }

    public void invalidate() {
        this.animation.finalize(this);
        this.sync();
    }

    public Vec3 pos() {
        return new Vec3(this.x, this.y, this.z);
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public <T> T getOrCreateProperty(String key, Supplier<T> value) {
        if (!this.properties.containsKey(key)) {
            this.properties.put(key, value.get());
        }
        return this.getProperty(key);
    }

    public <T> void setProperty(String key, T value) {
        this.properties.put(key, value);
    }

    public void setPos(Vec3 vec3) {
        this.x = vec3.f_82479_;
        this.y = vec3.f_82480_;
        this.z = vec3.f_82481_;
    }
}

