/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.elements;

import java.util.Arrays;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ElementTypes;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class GroupElement
implements AnimationElement {
    private final AnimationElement[] elements;

    public GroupElement(AnimationElement[] elements) {
        this.elements = elements;
    }

    @NotNull
    public Type getType() {
        return (Type)ElementTypes.GROUP.get();
    }

    @Override
    public int createLength(ParticleConfig config) {
        int max = 0;
        for (AnimationElement element : this.elements) {
            int check = element.createLength(config);
            if (check <= max) continue;
            max = check;
        }
        return max;
    }

    @Override
    public void tick(ParticleConfig object, int tick, double percentage) {
        for (AnimationElement element : this.elements) {
            element.tick(object, tick, percentage);
        }
    }

    public static class Type
    implements AnimationElement.Type<GroupElement> {
        @Override
        public GroupElement fromNW(FriendlyByteBuf buf) {
            AnimationElement[] elements = (AnimationElement[])NetworkHelper.readArray(buf, AnimationElement[]::new, AnimationElement::fromNw);
            return new GroupElement(elements);
        }

        @Override
        public void toNW(FriendlyByteBuf buf, GroupElement value) {
            NetworkHelper.writeArray(buf, value.elements, AnimationElement::toNw);
        }
    }

    public static class Builder
    implements AnimationElement.Builder {
        private final AnimationElement.Builder[] builders;

        public Builder(AnimationElement.Builder ... builders) {
            this.builders = builders;
        }

        @Override
        public AnimationElement build() {
            return new GroupElement((AnimationElement[])Arrays.stream(this.builders).map(AnimationElement.Builder::build).toArray(AnimationElement[]::new));
        }
    }
}

