/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.elements;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ElementTypes;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class KeepAliveElement
implements AnimationElement {
    private final int duration;

    public KeepAliveElement(int duration) {
        this.duration = duration;
    }

    public static Builder forDuration(int duration) {
        return new Builder().duration(duration);
    }

    @NotNull
    public Type getType() {
        return (Type)ElementTypes.KEEP_ALIVE.get();
    }

    @Override
    public int createLength(ParticleConfig config) {
        return this.duration;
    }

    @Override
    public void tick(ParticleConfig object, int tick, double percentage) {
        object.age = 0;
    }

    public static class Builder
    implements AnimationElement.Builder {
        private int duration;

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public AnimationElement build() {
            return new KeepAliveElement(this.duration);
        }
    }

    public static class Type
    implements AnimationElement.Type<KeepAliveElement> {
        @Override
        public KeepAliveElement fromNW(FriendlyByteBuf buf) {
            return new KeepAliveElement(buf.readInt());
        }

        @Override
        public void toNW(FriendlyByteBuf buf, KeepAliveElement value) {
            buf.writeInt(value.duration);
        }
    }
}

