/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.terminators.core;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimationManager;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimator;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTriggerInstance;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.network.FriendlyByteBuf;

public interface TerminationTrigger<T extends TerminationTriggerInstance> {
    public void addListener(ParticleAnimator var1, Listener<T> var2);

    public void removeListener(ParticleAnimator var1, Listener<T> var2);

    public void clearListeners(ParticleAnimator var1);

    public void toNw(FriendlyByteBuf var1, T var2);

    public T fromNw(FriendlyByteBuf var1);

    public static <T extends TerminationTriggerInstance> void writeToNw(FriendlyByteBuf buf, T terminator) {
        TerminationTrigger<? extends TerminationTriggerInstance> trigger = terminator.getTrigger();
        buf.writeRegistryIdUnsafe(ExtraRegistries.TERMINATION_TRIGGERS, trigger);
        trigger.toNw(buf, terminator);
    }

    public static TerminationTriggerInstance readFromNw(FriendlyByteBuf buf) {
        TerminationTrigger trigger = (TerminationTrigger)buf.readRegistryIdUnsafe(ExtraRegistries.TERMINATION_TRIGGERS);
        return trigger.fromNw(buf);
    }

    public record Listener<T extends TerminationTriggerInstance>(T trigger, ParticleAnimator animator) {
        public void run(ParticleAnimationManager manager) {
            manager.remove(this.animator);
        }

        public boolean isFor(ParticleAnimator animator) {
            return this.animator == animator;
        }
    }
}

