/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColor;
import net.kapitencraft.kap_lib.client.font.effect.EffectsStyle;
import net.kapitencraft.kap_lib.client.font.effect.GlyphEffect;
import net.kapitencraft.kap_lib.client.shaders.ModRenderTypes;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.registry.custom.GlyphEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;

public class SelectChatColorWidget
extends PositionedWidget {
    private final Consumer<ColorType> valueSink;
    private final Component title;
    private final Font font;
    private ColorType value;
    private static final ColorType[] COLOR_TYPES = SelectChatColorWidget.createColorTypes();
    private static final TextColor[] COLOR_LOOKUP = SelectChatColorWidget.createLookup();
    private static final int COLOR_TYPE_COUNT = 17;
    private static final int COLOR_SIZE = 10;

    public SelectChatColorWidget(int x, int y, Consumer<ColorType> valueSink, Component title, Font font, ColorType value) {
        super(x, y, 100, 136);
        this.valueSink = valueSink;
        this.title = title;
        this.font = font;
        if (font.m_92852_((FormattedText)title) > 90) {
            KapLibMod.LOGGER.warn("title for chat color select wider than feasible");
        }
        this.value = value;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280509_(this.x, this.y, this.getMaxX(), this.getMaxY(), -12566464);
        pGuiGraphics.m_280653_(this.font, this.title, this.x + this.width / 2, this.y + 2, 0xFFFFFF);
        for (int i = 0; i < 17; ++i) {
            ColorType type = COLOR_TYPES[i];
            int x = this.x + 2 + i % 4 * 24;
            int y = this.y + 14 + i / 4 * 24;
            int xOffset = i % 4;
            if (type == this.value) {
                pGuiGraphics.m_280509_(x - 1, y - 1, x + 21, y + 21, 0xC0C0C0);
            }
            type.render(pGuiGraphics, x, y, 20);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (int i = 0; i < 17; ++i) {
            int x = this.x + 2 + i % 4 * 22;
            int y = this.y + 14 + i / 4 * 22;
            if (!MathHelper.is2dBetween(pMouseX, pMouseY, x, y, x + 20, y + 20)) continue;
            ColorType type = COLOR_TYPES[i];
            if (this.value != type) {
                this.valueSink.accept(type);
                this.value = type;
            }
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private static TextColor[] createLookup() {
        return (TextColor[])Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::m_126664_).map(TextColor::m_131270_).toArray(TextColor[]::new);
    }

    public static ColorType getColor(EnchantmentColor color) {
        Style style = color.targetStyle();
        EffectsStyle effectsStyle = EffectsStyle.of(style);
        if (effectsStyle.hasEffect((GlyphEffect)GlyphEffects.RAINBOW.get())) {
            return COLOR_TYPES[16];
        }
        for (int i = 0; i < 16; ++i) {
            if (!COLOR_LOOKUP[i].equals((Object)style.m_131135_())) continue;
            return COLOR_TYPES[i];
        }
        throw new IllegalArgumentException("could not extract color from style: " + style);
    }

    private static ColorType[] createColorTypes() {
        List types = Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::m_126664_).map(VanillaColorType::new).collect(Collectors.toCollection(ArrayList::new));
        types.add(new ChromaColorType());
        return (ColorType[])types.toArray(ColorType[]::new);
    }

    public static interface ColorType {
        public void render(GuiGraphics var1, int var2, int var3, int var4);

        public Style getStyle();
    }

    private static class ChromaColorType
    implements ColorType {
        private static final Style CHROMA_STYLE = MiscHelper.withSpecial(Style.f_131099_, GlyphEffects.RAINBOW);

        private ChromaColorType() {
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width) {
            graphics.m_285944_(ModRenderTypes.FILL_CHROMA, x, y, x + width, y + width, 0);
        }

        @Override
        public Style getStyle() {
            return CHROMA_STYLE;
        }
    }

    private record VanillaColorType(ChatFormatting formatting, Style formattedStyle) implements ColorType
    {
        public VanillaColorType(@NotNull ChatFormatting formatting) {
            this(formatting, Style.f_131099_.m_131140_(formatting));
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width) {
            graphics.m_280509_(x, y, x + width, y + width, 0xFF000000 | this.formatting.m_126665_());
        }

        @Override
        public Style getStyle() {
            return this.formattedStyle;
        }
    }
}

