/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget;

import java.util.function.Consumer;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.range.simple.IntegerNumberRange;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class SelectCountWidget
extends PositionedWidget {
    private final Consumer<Integer> valueSink;
    private final IntegerNumberRange range;
    private boolean dragging;
    private int value;
    private final Component title;
    private final Font font;

    public SelectCountWidget(int x, int y, int width, Font font, int value, Consumer<Integer> valueSink, IntegerNumberRange range, Component title) {
        super(x, y, width, 45);
        this.valueSink = valueSink;
        this.range = range;
        this.title = title;
        this.font = font;
        this.value = value;
    }

    int getMinX() {
        return this.x + 10 + (this.value - this.range.getMin()) * (this.width - 25) / this.range.getRange();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280509_(this.x, this.y, this.getMaxX(), this.getMaxY(), -12566464);
        pGuiGraphics.m_280653_(this.font, this.title, this.x + this.width / 2, this.y + 2, 0xFFFFFF);
        pGuiGraphics.m_280653_(this.font, (Component)Component.m_237110_((String)"number_value", (Object[])new Object[]{this.value}), this.x + this.width / 2, this.y + 12, 0xFFFFFF);
        pGuiGraphics.m_280509_(this.x + 10, this.getMaxY() - 15, this.getMaxX() - 10, this.getMaxY() - 10, -1);
        int minVal = this.getMinX();
        pGuiGraphics.m_280509_(minVal, this.getMaxY() - 20, minVal + 5, this.getMaxY() - 5, this.dragging ? -4737097 : -9408400);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int minVal = this.getMinX();
        if (MathHelper.is2dBetween(pMouseX, pMouseY, minVal, this.getMaxY() - 15, minVal + 5, this.getMaxY() - 10)) {
            this.dragging = true;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            int delta = Math.max((int)pMouseX - (this.x + 10), 0);
            int value = Math.min(this.range.getMin() + delta * this.range.getRange() / (this.width - 20), this.range.getMax());
            if (this.value != value) {
                this.valueSink.accept(value);
                this.value = value;
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.dragging = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }
}

