/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SelectEnumWidget<T>
extends PositionedWidget {
    private static final Component SELECT_PANEL = Component.m_237115_((String)"mco.template.button.select");
    private final Font font;
    private final List<T> values;
    private final Function<T, Component> nameExtractor;
    private final Consumer<T> valueSink;
    private final Component title;
    private final int titleWidth;
    private T selected;

    public SelectEnumWidget(int x, int y, int width, int height, Font font, List<T> values, Function<T, Component> nameExtractor, Consumer<T> valueSink, Component title) {
        super(x, y, width, height);
        this.font = font;
        this.values = values;
        this.nameExtractor = nameExtractor;
        this.valueSink = valueSink;
        this.title = title;
        this.titleWidth = this.font.m_92852_((FormattedText)title);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280509_(this.x, this.y, this.getMaxX(), this.getMaxY(), -12566464);
        pGuiGraphics.m_280653_(this.font, this.title, this.x + this.width / 2, this.y + 1, 0xFFFFFF);
        pGuiGraphics.m_280588_(this.x + 2, this.y + 12, this.getMaxX() - 2, this.getMaxY() - 12);
        int selectedIndex = (pMouseY - this.y - 12) / 10;
        for (int i = 0; i < this.values.size(); ++i) {
            T t = this.values.get(i);
            int y = this.y + 12 + i * 10;
            pGuiGraphics.m_280509_(this.x + 2, y - 1, this.getMaxX() - 3, y + 9, this.selected == t ? -8355712 : (i == selectedIndex ? -9408400 : -10461088));
            pGuiGraphics.m_280430_(this.font, this.nameExtractor.apply(t), this.x + 3, y, 0xFFFFFF);
        }
        pGuiGraphics.m_280618_();
        pGuiGraphics.m_280430_(this.font, SELECT_PANEL, this.getMaxX() - (this.titleWidth + 2), this.getMaxY() - 10, 0xFFFFFF);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int selectedIndex = ((int)pMouseY - this.y - 12) / 10;
        if (MathHelper.validIndex(this.values, selectedIndex)) {
            this.selected = this.values.get(selectedIndex);
            return true;
        }
        int selectPos = this.getMaxX() - (this.titleWidth + 2);
        if (MathHelper.is2dBetween(pMouseX, pMouseY, selectPos - 1, this.getMaxY() - 10, selectPos + this.titleWidth + 1, this.getMaxY()) && this.selected != null) {
            this.valueSink.accept(this.selected);
            this.selected = null;
            return true;
        }
        return false;
    }
}

