/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.select;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import net.kapitencraft.kap_lib.client.widget.select.SelectRegistryElementWidget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SelectItemWidget
extends SelectRegistryElementWidget<Item> {
    private static final int ITEM_WIDTH_WITH_OFFSET = 18;
    private static final List<ItemStack> itemsCache = StreamSupport.stream(ForgeRegistries.ITEMS.spliterator(), false).map(Item::m_7968_).toList();
    private final int xOffset;
    private final int elementsPerRow;
    private final int maxHeight;

    protected SelectItemWidget(int x, int y, int width, int height, Component title, Font font, Consumer<Item> itemSink) {
        super(x, y, width, height, title, font, ForgeRegistries.ITEMS, itemSink);
        this.xOffset = (this.width - 2) % 18 / 2;
        this.elementsPerRow = (this.width - 2 - this.xOffset * 2) / 18;
        this.maxHeight = 18 * (itemsCache.size() / this.elementsPerRow);
    }

    @Override
    protected int getHoveredIndex(double pMouseX, double pMouseY) {
        return 0;
    }

    @Override
    protected void renderInternal(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int minIndex = (int)this.scroll / 18 * this.elementsPerRow;
        int maxIndex = ((int)this.scroll + this.height) / 18 * this.elementsPerRow;
        for (int i = minIndex; i < maxIndex; ++i) {
            int column = i % this.elementsPerRow;
            int row = i / this.elementsPerRow;
            graphics.m_280480_(itemsCache.get(i), this.xOffset + column * 18, (int)this.scroll + row * 18);
        }
    }

    @Override
    protected int size() {
        return this.allElements.size() / this.elementsPerRow * 18;
    }
}

