/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.io.network.ModMessages;
import net.kapitencraft.kap_lib.io.network.S2C.capability.CooldownStartedPacket;
import net.kapitencraft.kap_lib.io.network.S2C.capability.SyncCooldownsToPlayerPacket;
import net.kapitencraft.kap_lib.util.IntegerReference;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Cooldowns {
    public static final Capability<Cooldowns> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Cooldowns>(){});
    private final LivingEntity entity;
    private final Map<Cooldown, IntegerReference> active = new HashMap<Cooldown, IntegerReference>();

    public Cooldowns(LivingEntity entity) {
        this.entity = entity;
    }

    public boolean isActive(Cooldown cooldown) {
        return this.active.containsKey(cooldown);
    }

    public void tick() {
        ArrayList toRemove = new ArrayList();
        this.active.forEach((cooldown, integerReference) -> {
            integerReference.decrease();
            if (integerReference.getIntValue() <= 0) {
                toRemove.add(cooldown);
            }
        });
        toRemove.forEach(c -> {
            c.onDone(this.entity);
            this.active.remove(c);
        });
    }

    public void applyCooldown(Cooldown cooldown, boolean reduceWithTime) {
        int time = cooldown.getCooldownTime(this.entity, reduceWithTime);
        if (time > 0) {
            this.active.put(cooldown, IntegerReference.create(time));
            ModMessages.sendToAllConnectedPlayers(p -> new CooldownStartedPacket(cooldown, time, this.entity.m_19879_()), (ServerLevel)this.entity.m_9236_());
        }
    }

    public int getCooldownTime(Cooldown cooldown) {
        IntegerReference reference = this.active.get(cooldown);
        return reference == null ? 0 : reference.getIntValue();
    }

    public Map<Cooldown, Integer> getData() {
        HashMap<Cooldown, Integer> map = new HashMap<Cooldown, Integer>();
        this.active.forEach((cooldown, integerReference) -> map.put((Cooldown)cooldown, integerReference.getIntValue()));
        return map;
    }

    public void loadData(Map<Cooldown, Integer> map) {
        map.forEach((cooldown, integer) -> this.active.put((Cooldown)cooldown, IntegerReference.create(integer)));
    }

    public static Cooldowns get(LivingEntity living) {
        return (Cooldowns)living.getCapability(CAPABILITY).orElseThrow(() -> new NullPointerException("unable to get capability"));
    }

    public static void send(ServerPlayer sP) {
        Cooldowns cooldown = Cooldowns.get((LivingEntity)sP);
        ModMessages.sendToClientPlayer(new SyncCooldownsToPlayerPacket(sP.m_19879_(), cooldown.getData()), sP);
    }

    public void setCooldownTime(Cooldown cooldown, int duration) {
        this.active.put(cooldown, IntegerReference.create(duration));
    }
}

