/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;

public class ExtraNumbersLangProvider
extends LanguageProvider {
    static final List<Pair<Integer, String>> latins = List.of(Pair.of((Object)1, (Object)"I"), Pair.of((Object)5, (Object)"V"), Pair.of((Object)10, (Object)"X"), Pair.of((Object)50, (Object)"L"), Pair.of((Object)100, (Object)"C"), Pair.of((Object)500, (Object)"D"), Pair.of((Object)1000, (Object)"M"));

    public ExtraNumbersLangProvider(PackOutput output) {
        super(output, "extra_numbers", "en_us");
    }

    protected void addTranslations() {
        int i;
        for (i = 6; i < 255; ++i) {
            this.add("potion.potency." + i, ExtraNumbersLangProvider.makeLatin(i + 1));
        }
        for (i = 11; i < 255; ++i) {
            this.add("enchantment.level." + i, ExtraNumbersLangProvider.makeLatin(i));
        }
    }

    private static String makeLatin(int in) {
        StringBuilder s = new StringBuilder();
        block0: while (in > 0) {
            block1: for (int i = latins.size() - 1; i >= 0; --i) {
                Pair<Integer, String> element = latins.get(i);
                if ((Integer)element.getFirst() <= in) {
                    s.append((String)element.getSecond());
                    in -= ((Integer)element.getFirst()).intValue();
                    continue block0;
                }
                for (int i1 = 0; i1 < i; i1 += 2) {
                    Pair<Integer, String> e1 = latins.get(i1);
                    if ((Integer)element.getFirst() - (Integer)e1.getFirst() > in) continue;
                    s.append((String)e1.getSecond()).append((String)element.getSecond());
                    in -= (Integer)element.getFirst() - (Integer)e1.getFirst();
                    continue block1;
                }
            }
        }
        return s.toString();
    }

    public String m_6055_() {
        return "EXTRA_NUMBERS";
    }
}

