/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public abstract class EnglishLanguageProvider
extends LanguageProvider {
    private final String modId;

    public EnglishLanguageProvider(PackOutput output, String modId) {
        super(output, modId, "en_us");
        this.modId = modId;
    }

    public void addDeathMessage(String msgId, String msg) {
        this.add("death.attack." + msgId, msg);
        this.add("death.attack." + msgId + ".item", msg + " using %3$s");
    }

    public void addItem(RegistryObject<Item> item) {
        this.addItem((Supplier)item, TextHelper.makeGrammar(item.getId().m_135815_()));
    }

    public void bonusWithTranslation(boolean set, String key, String name, String ... description) {
        String translationKey = (set ? "set." : "") + "bonus." + this.modId + "." + key;
        this.add(translationKey, name);
        this.translation(translationKey, description);
    }

    public void addEnchantmentWithDescription(RegistryObject<Enchantment> enchantment, String ... description) {
        String id = ((Enchantment)enchantment.get()).m_44704_();
        this.add(id, TextHelper.makeGrammar(enchantment.getId().m_135815_()));
        this.translation(id, description);
    }

    public void addAttribute(RegistryObject<Attribute> attribute, @Nullable ChatFormatting color) {
        String id = attribute.getId().m_135815_();
        String name = (String)(color != null ? "\u00a7" + color.m_178510_() : "") + TextHelper.makeGrammar(CollectionHelper.getLast(id.split("\\.")));
        this.add(id, name);
        String descriptionId = ((Attribute)attribute.get()).m_22087_();
        if (!id.equals(descriptionId)) {
            this.add(descriptionId, name);
        }
    }

    protected void translation(String baseName, String ... description) {
        baseName = (String)baseName + ".desc";
        for (int i = 0; i < description.length; ++i) {
            this.add((String)baseName + (String)(i == 0 ? "" : "." + i), description[i]);
        }
    }
}

