/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.crafting.serializers.ArmorRecipe;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final Map<ArmorItem.Type, ? extends RegistryObject<? extends Item>> items;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;
    private Ingredient material;

    private ArmorRecipeBuilder(Map<ArmorItem.Type, ? extends RegistryObject<? extends Item>> items) {
        this.items = items;
    }

    public static ArmorRecipeBuilder create(Map<ArmorItem.Type, ? extends RegistryObject<? extends Item>> items) {
        return new ArmorRecipeBuilder(items);
    }

    @NotNull
    public RecipeBuilder m_126132_(@NotNull String pCriterionName, @NotNull CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public RecipeBuilder material(Ingredient ingredient) {
        this.material = ingredient;
        return this;
    }

    public RecipeBuilder material(Item item) {
        this.m_126132_(ArmorRecipeBuilder.getHasName((ItemLike)item), (CriterionTriggerInstance)ArmorRecipeBuilder.has((ItemLike)item));
        return this.material(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public RecipeBuilder material(RegistryObject<? extends Item> registryObject) {
        return this.material((Item)registryObject.get());
    }

    @NotNull
    public Item m_142372_() {
        return (Item)this.items.values().iterator().next().get();
    }

    public void m_176498_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        KapLibMod.LOGGER.warn("call to Armor Recipe save without recipe location definition");
        super.m_176498_(pFinishedRecipeConsumer);
    }

    protected static String getHasName(ItemLike pItemLike) {
        return "has_" + ArmorRecipeBuilder.getItemName(pItemLike);
    }

    protected static String getItemName(ItemLike pItemLike) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)pItemLike.m_5456_()).m_135815_();
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike pItemLike) {
        return ArmorRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{pItemLike}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... pPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, pPredicates);
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept((FinishedRecipe)new Result(pRecipeId, this.advancement, pRecipeId.m_246208_("recipes/combat/"), this.group, this.material, this.items));
    }

    private static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final String group;
        private final Ingredient material;
        private final Map<ArmorItem.Type, ? extends RegistryObject<? extends Item>> items;

        private Result(ResourceLocation id, Advancement.Builder advancement, ResourceLocation advancementId, String group, Ingredient material, Map<ArmorItem.Type, ? extends RegistryObject<? extends Item>> items) {
            super(CraftingBookCategory.EQUIPMENT);
            this.id = id;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.group = group;
            this.material = material;
            this.items = items;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ExtraRecipeSerializers.ARMOR.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        public void m_7917_(JsonObject pJson) {
            super.m_7917_(pJson);
            pJson.addProperty("group", this.group);
            pJson.add("material", this.material.m_43942_());
            this.serializeItemDefinition(pJson);
        }

        private void serializeItemDefinition(JsonObject object) {
            boolean saveAsString = true;
            String typeDef = null;
            for (Map.Entry<ArmorItem.Type, ? extends RegistryObject<? extends Item>> entry : this.items.entrySet()) {
                ArmorRecipe.ArmorType type = ArmorRecipe.ArmorType.fromEquipmentSlot(entry.getKey());
                ResourceLocation location = entry.getValue().getId();
                String typeSuffix = "_" + type.m_7912_();
                if (!location.m_135815_().endsWith(typeSuffix)) {
                    saveAsString = false;
                }
                if (!saveAsString || typeDef != null) continue;
                typeDef = location.m_247266_(s -> s.substring(0, s.length() - typeSuffix.length())).toString();
            }
            if (saveAsString) {
                object.addProperty("results", typeDef);
            } else {
                JsonArray array = new JsonArray();
                this.items.values().stream().map(RegistryObject::getId).map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                object.add("results", (JsonElement)array);
            }
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

